/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.model;

import com.thinkbuzan.gaia.printing.service.impl.PrintingServiceImpl;
import com.thinkbuzan.gaia.printing.service.model.Margins;
import java.awt.print.PageFormat;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;

public class PrintServiceAttribute {
    private MediaTray mediaTray;
    private int copies = 1;
    private PrintService printService;
    private boolean collate = false;
    private static final float DEFAULT_MARGINS = 0.0f;
    private Margins margins = new Margins(0.0f, 0.0f, 0.0f, 0.0f);
    private MediaSizeName mediaSizeName = MediaSizeName.ISO_A4;
    private MediaSize mediaSize = null;
    private int orientation = 0;

    public PrintServiceAttribute(PrintService printService) {
        this.printService = printService;
    }

    public final boolean isCollate() {
        return this.collate;
    }

    public final void setCollate(boolean bl) {
        this.collate = bl;
    }

    public final PrintService getPrintService() {
        return this.printService;
    }

    public final void setPrintService(PrintService printService) {
        this.validateSetPrintService(printService);
        this.printService = printService;
    }

    private void validateSetPrintService(PrintService printService) {
        if (null == printService || null == printService.getAttributes()) {
            throw new IllegalArgumentException("Can't set PrintService null value.");
        }
    }

    private void validateSetPageFormat(PageFormat pageFormat) {
        if (null == pageFormat) {
            throw new IllegalArgumentException("Can't set PageFormat null value.");
        }
    }

    public final MediaTray getMediaTray() {
        return this.mediaTray;
    }

    public final void setMediaTray(MediaTray mediaTray) {
        this.mediaTray = mediaTray;
    }

    public final MediaSize getMediaSize() {
        return this.mediaSize;
    }

    public final MediaSizeName getMediaSizeName() {
        return this.mediaSizeName;
    }

    public final void setMediaSize(MediaSize mediaSize) {
        this.mediaSize = mediaSize;
    }

    public final void setMediaSizeName(MediaSizeName mediaSizeName) {
        this.validateSetMediaSizeName(mediaSizeName);
        this.mediaSizeName = mediaSizeName;
        this.mediaSize = MediaSize.getMediaSizeForName(this.mediaSizeName);
    }

    private void validateSetMediaSizeName(MediaSizeName mediaSizeName) {
        if (null == mediaSizeName) {
            throw new IllegalArgumentException("Can't set MediaSizeName null value.");
        }
    }

    public final void setCopies(int n) {
        this.validateSetCopoies(n);
        this.copies = n;
    }

    public final int getCopies() {
        return this.copies;
    }

    private void validateSetCopoies(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The copies must greater than zero(0).");
        }
    }

    public final void setMargins(Margins margins) {
        this.margins = margins;
    }

    public final Margins getMargins() {
        return this.margins;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public PageFormat createPageFormat(PrintService printService) {
        PageFormat pageFormat = null;
        pageFormat = null == this.mediaSize ? PrintingServiceImpl.createFormat(this.mediaSizeName, this.margins, this.orientation, printService) : PrintingServiceImpl.createFormat(this.mediaSize, this.margins, this.orientation, printService);
        return pageFormat;
    }
}

