/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.model;

import com.thinkbuzan.gaia.printing.service.model.Alignment;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PrintTextComponent {
    private static final int DEFAULT_FONT_SIZE = 12;
    private Font font = new Font("Dialog", 0, 12);
    private String tagExpression;
    private Alignment alignment = Alignment.CENTER;
    private static final String MAP_NAME = "\\{MAP_NAME\\}";
    private static final String PRINT_DATE = "\\{PRINT_DATE\\}";
    private Color fontColor = Color.BLACK;

    public final Font getFont() {
        return this.font;
    }

    public final void setFont(Font font) {
        this.validateSetFont(font);
        this.font = font;
    }

    private void validateSetFont(Font font) {
        if (null == font) {
            throw new IllegalArgumentException("The font can't be null.");
        }
    }

    public final String getTagExpression() {
        if (null == this.tagExpression) {
            return "";
        }
        return this.tagExpression;
    }

    public final void setTagExpression(String string) {
        this.tagExpression = string;
    }

    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(Alignment alignment) {
        this.validateSetAlignment(alignment);
        this.alignment = alignment;
    }

    private void validateSetAlignment(Alignment alignment) {
        if (null == alignment) {
            throw new IllegalArgumentException("The alignment can't be null.");
        }
    }

    public final String getTagValue(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String string2 = simpleDateFormat.format(new Date());
        if (null == string) {
            return this.getTagExpression().replaceAll(PRINT_DATE, string2);
        }
        return this.getTagExpression().replaceAll(PRINT_DATE, string2).replaceAll(MAP_NAME, string);
    }

    public final Color getFontColor() {
        return this.fontColor;
    }

    public final void setFontColor(Color color) {
        this.validateSetFontColor(color);
        this.fontColor = color;
    }

    private void validateSetFontColor(Color color) {
        if (null == color) {
            throw new IllegalArgumentException("Can't set font color null value.");
        }
    }
}

