/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.osgi;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.impl.PrintingServiceImpl;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.service.osgi.I18nWrapper;
import com.thinkbuzan.phoenix.licensing.License;
import com.thinkbuzan.phoenix.licensing.LicenseType;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import javax.print.PrintServiceLookup;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final transient Logger LOGGER = Logger.getLogger(Activator.class);
    private transient ServiceRegistration registration;
    private static transient PluginLicenseService pluginLicenseService;

    public final void start(BundleContext bundleContext) {
        OSGiService oSGiService = new OSGiService(bundleContext, PluginLicenseService.class);
        pluginLicenseService = (PluginLicenseService)oSGiService.get();
        oSGiService.close();
        I18n i18n = (I18n)new OSGiService(bundleContext, I18n.class).get();
        I18nWrapper.setI18n(i18n);
        PrintingServiceImpl printingServiceImpl = new PrintingServiceImpl(new PrintServiceAttribute(PrintServiceLookup.lookupDefaultPrintService()), i18n);
        this.registration = bundleContext.registerService(PrintingService.class.getName(), (Object)printingServiceImpl, null);
    }

    public static boolean isLicenseTypeTrial() {
        return Activator.isLicenseType(LicenseType.trial);
    }

    public static boolean isLicenseTypeBasic() {
        return Activator.isLicenseType(LicenseType.basic);
    }

    private static boolean isLicenseType(LicenseType licenseType) {
        License license;
        if (pluginLicenseService == null) {
            LOGGER.error((Object)"Did not expect pluginLicenseService to be null");
            license = null;
        } else {
            license = pluginLicenseService.getLicense(false);
        }
        if (license == null) {
            LOGGER.error((Object)"Did not expect license to be null");
            return licenseType == LicenseType.basic;
        }
        return licenseType.equals((Object)license.getType());
    }

    public static void setPluginLicenseService(PluginLicenseService pluginLicenseService) {
        Activator.pluginLicenseService = pluginLicenseService;
    }

    public final void stop(BundleContext bundleContext) {
        this.registration.unregister();
    }
}

