/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.printable;

import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.printing.service.IPrintable;
import com.thinkbuzan.pascal.services.editor.IPainter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class AbstractPainterPrintable
implements IPrintable {
    private final transient IEditorComponent editorComp;
    private transient boolean background = false;
    private transient boolean fillPage = false;

    public AbstractPainterPrintable(IEditorComponent iEditorComponent) {
        this.editorComp = iEditorComponent;
    }

    public final int getHeight() {
        return this.getPainter().getPaintBounds().getBounds().height;
    }

    public final int getWidth() {
        return this.getPainter().getPaintBounds().getBounds().width;
    }

    public final void paint(Graphics2D graphics2D) {
        IPainter iPainter = this.getPainter();
        iPainter.setBackgroundPainted(this.background);
        iPainter.paint(graphics2D);
    }

    public final void paint(Graphics2D graphics2D, Rectangle rectangle) {
        IPainter iPainter = this.getPainter();
        iPainter.setBackgroundPainted(this.background);
        iPainter.paint(graphics2D, (Rectangle2D)rectangle);
    }

    public final void setBackgroundPainted(boolean bl) {
        this.background = bl;
    }

    public final boolean isBackgroundPainted() {
        return this.background;
    }

    public final void setFillPage(boolean bl) {
        this.fillPage = bl;
    }

    public final boolean isFillPage() {
        return this.fillPage;
    }

    protected abstract IPainter getPainter();

    protected final IEditorComponent getEditorComp() {
        return this.editorComp;
    }
}

