/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.printable;

import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.printing.service.IPrintable;
import com.thinkbuzan.pascal.services.editor.IPainter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class RegionPrintable
implements IPrintable {
    private final transient IEditorComponent editorComp;
    private transient IPainter regionPainter;
    private transient Rectangle2D bounds;
    private transient boolean enforceRegion;

    public RegionPrintable(IEditorComponent iEditorComponent, Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
        this.editorComp = iEditorComponent;
    }

    public final int getHeight() {
        int n = this.enforceRegion ? (int)(this.bounds.getHeight() * (double)this.getPainter().getPaintBounds().getBounds().height) : this.getPainter().getPaintBounds().getBounds().height;
        return n;
    }

    public final int getWidth() {
        int n = this.enforceRegion ? (int)(this.bounds.getWidth() * (double)this.getPainter().getPaintBounds().getBounds().width) : this.getPainter().getPaintBounds().getBounds().width;
        return n;
    }

    protected final IEditorComponent getEditorComp() {
        return this.editorComp;
    }

    protected final IPainter getPainter() {
        if (this.regionPainter == null) {
            this.regionPainter = this.getEditorComp().createPainter(true, false);
        }
        return this.regionPainter;
    }

    public final void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public final void setRegionEnabled(boolean bl) {
        this.enforceRegion = bl;
    }

    public final void paint(Graphics2D graphics2D) {
        Object object;
        if (this.enforceRegion) {
            object = this.getPainter().getPaintBounds().getBounds();
            graphics2D.translate(-(this.bounds.getX() * ((RectangularShape)object).getWidth()), -(this.bounds.getY() * ((RectangularShape)object).getHeight()));
            graphics2D.setClip((int)(this.bounds.getX() * ((RectangularShape)object).getWidth()), (int)(this.bounds.getY() * ((RectangularShape)object).getHeight()), (int)(this.bounds.getWidth() * ((RectangularShape)object).getWidth()), (int)(this.bounds.getHeight() * ((RectangularShape)object).getHeight()));
        }
        object = this.getPainter();
        object.setBackgroundPainted(true);
        object.paint(graphics2D);
    }

    public final Rectangle getPainterBounds() {
        return this.getPainter().getPaintBounds().getBounds();
    }
}

