/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.resource;

import com.thinkbuzan.gaia.printing.service.osgi.Activator;
import com.thinkbuzan.gaia.printing.service.osgi.I18nWrapper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ResourceManager {
    private static final transient Map<String, BufferedImage> IMAGE_CACHE = new HashMap<String, BufferedImage>();
    private static final String WATERMARK_BASIC_PREFIX = "wm_basic_";
    private static final String WATERMARK_TRIAL_PREFIX = "wm_trial_";
    private static final String WATERMARK_EXTENSION = ".png";

    private ResourceManager() {
    }

    private static void validateGetImageIcon(String string) {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException(" image file name can't be null or empty");
        }
        InputStream inputStream = ResourceManager.class.getResourceAsStream(string);
        if (null == inputStream) {
            throw new IllegalArgumentException(" image file doesn't exsit.");
        }
    }

    public static BufferedImage getWaterMarkImage() {
        String string = Activator.isLicenseTypeTrial() ? WATERMARK_TRIAL_PREFIX : WATERMARK_BASIC_PREFIX;
        Locale locale = I18nWrapper.getI18n().getUserLocale();
        String string2 = locale != null && ResourceManager.isAvailable(locale) ? I18nWrapper.getI18n().getUserLocale().getLanguage() : "en";
        return ResourceManager.getBufferedImage(string + string2 + WATERMARK_EXTENSION);
    }

    private static boolean isAvailable(Locale locale) {
        return locale.equals(Locale.JAPAN) || locale.equals(Locale.ENGLISH);
    }

    private static BufferedImage getBufferedImage(String string) {
        return ResourceManager.getBufferedImage(string, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getBufferedImage(String string, int n) {
        Object object;
        ResourceManager.validateGetImageIcon(string);
        Object object2 = IMAGE_CACHE;
        synchronized (object2) {
            object = IMAGE_CACHE.get(string);
        }
        if (object == null) {
            try {
                Object object3;
                object2 = ResourceManager.class.getResourceAsStream(string);
                object = ImageIO.read((InputStream)object2);
                if (n != -1 && ((BufferedImage)object).getType() != n) {
                    object3 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), n);
                    Graphics2D graphics2D = (Graphics2D)((BufferedImage)object3).getGraphics();
                    graphics2D.drawImage((Image)object, 0, 0, null);
                    graphics2D.dispose();
                    object = object3;
                }
                object3 = IMAGE_CACHE;
                synchronized (object3) {
                    IMAGE_CACHE.put(string, (BufferedImage)object);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(String.format("Could not get BufferedImage \"%s\"", string));
            }
        }
        return object;
    }
}

