/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.novamind;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.importer.novamind.NovaMindImporter;
import com.thinkbuzan.gaia.importer.novamind.license.BundleLicenser;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.ImportManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext bundleContext) {
        this.registerNovaMindImporter(bundleContext);
    }

    private void registerNovaMindImporter(BundleContext bundleContext) {
        BundleLicenser bundleLicenser = new BundleLicenser(bundleContext);
        OSGiService oSGiService = new OSGiService(bundleContext, ImportManager.class);
        if (bundleLicenser.isNovaMindImportLicensed()) {
            ((ImportManager)oSGiService.get()).register((IImporter)new NovaMindImporter(this.getI18n(bundleContext)));
        } else {
            ((ImportManager)oSGiService.get()).registerUnlicensed((IImporter)new NovaMindImporter(this.getI18n(bundleContext)));
        }
        oSGiService.close();
    }

    private final I18n getI18n(BundleContext bundleContext) {
        I18n i18n = (I18n)new OSGiService(bundleContext, I18n.class).get();
        i18n.register(new ITextBundle(){

            public final ClassLoader getClassLoader() {
                return Activator.class.getClassLoader();
            }

            public final String getPropertyFileBaseName() {
                return "/i18nproperties/NovaMindImporterMessages";
            }
        });
        return i18n;
    }

    public void stop(BundleContext bundleContext) {
    }
}

