/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.novamind;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBoundaryAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.AddRelationshipAction;
import com.thinkbuzan.gaia.editor.actions.BeginModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.EndModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.RunFullLayoutAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutEnabledAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.HyperLink;
import com.thinkbuzan.gaia.entities.HyperLinkType;
import com.thinkbuzan.gaia.entities.Notes;
import com.thinkbuzan.gaia.importer.novamind.resources.ResourceManager;
import com.thinkbuzan.gaia.importer.novamind.util.DecompressFileUtil;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.IImporterListener;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovaMindImporter
implements IImporter {
    private static final String UTC = "utc";
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String HOUR = "hour";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String MAP = "map";
    private static final String MAPS = "maps";
    private static final String NSCALENDAR_DATE = "NSCalendarDate";
    private static final String LAST_SAVE_DATE = "lastSaveDate";
    private static final String CREATION_DATE = "creationDate";
    private static final String NSFOREGROUND_COLOR_ATTRIBUTE_NAME = "NSForegroundColorAttributeName";
    private static final String NSCOLOR = "NSColor";
    private static final String GRAPHIC = "graphic";
    private static final String NSATTRIBUTED_STRING = "NSAttributedString";
    private static final String NMWIN_FONT = "NMWinFont";
    private static final String NMWIN_FONT_ATTRIBUTE_NAME = "NMWinFontAttributeName";
    private static final String FORMATTING = "formatting";
    private static final String BOUNDS = "bounds";
    private static final String NMENCLOSED_GRAPHIC = "NMEnclosedGraphic";
    private static final String NMGRAPHIC = "NMGraphic";
    private static final String ROOT = "root";
    private static final String CHILDREN = "children";
    private static final String NMMAPBRANCH = "NMMapBranch";
    private static final String ENCLOSEDTEXTAREA = "enclosedTextArea";
    private static final String STRING = "string";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String ENCLOSEDIMAGE = "enclosedImage";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String OTHERENCLOSEDGRAPHICS = "otherEnclosedGraphics";
    private static final String OTHERENCLOSEDGRAPHIC = "otherEnclosedGraphic";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String RED = "redComponent";
    private static final String GREEN = "greenComponent";
    private static final String BLUE = "blueComponent";
    private static final String LABEL = "Import NovaMind File";
    private static final String TEXT = "text";
    private static final String HYPERLINKS = "hyperlinks";
    private static final String HYPERLINK = "hyperlink";
    private static final String NMHYPERLINK = "NMHyperlink";
    private static final String ATTACHED_TEXT_ARRAY = "attachedTextArray";
    private static final String ITEM = "item";
    private static final String NM_ATTACHED_TEXT = "NMAttachedText";
    private static final Logger LOGGER = Logger.getLogger(NovaMindImporter.class);
    private final transient Map<String, mmIStructureCell> graphicNumberToCellMap;
    private final transient List<mmIStructureCell> cellsWithBoundaries;
    private transient mmIStructureCell parent;
    private transient mmIStructureCell current;
    private transient Element currentElement = new Element("central");
    private transient boolean isCentralIdea = true;
    private transient int progressCount = 0;
    private transient int currentProgress = 0;
    private transient IImporterListener novaMindListener;
    private final transient I18n i18n;
    private final transient String description;
    private static final List<String> EXTENSIONS = Arrays.asList("nmind");
    private static final String LINK_TYPE = "linkType";
    private static final String LINK_URL = "linkURL";

    public NovaMindImporter(I18n i18n) {
        this.graphicNumberToCellMap = new HashMap<String, mmIStructureCell>();
        this.cellsWithBoundaries = new ArrayList<mmIStructureCell>();
        this.i18n = i18n;
        this.description = this.i18n.getLocalizedText("com.thinkbuzan.i18n.novamindimporter.files");
    }

    public final void importFile(File file, IEditorComponent iEditorComponent, IImporterListener iImporterListener) {
        this.validateImportFile(file, iEditorComponent, iImporterListener);
        this.clearState();
        this.novaMindListener = iImporterListener;
        SAXBuilder sAXBuilder = new SAXBuilder();
        File file2 = DecompressFileUtil.decompress(file);
        if (file2 == null) {
            this.novaMindListener.importErrorOccurred(this.i18n.getLocalizedText("com.thinkbuzan.i18n.novamindimporter.decompressFailed"));
            throw new IllegalArgumentException("Error occured when decompressing file: " + file.getName());
        }
        file2.getParentFile().getParent();
        try {
            Document document = sAXBuilder.build(file2);
            Element element = document.getRootElement();
            this.parseMetaDataElement(element);
            Element element2 = this.getNMMapElement(element);
            iEditorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
            iEditorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(false));
            this.processNMMap(iEditorComponent, element2);
            iEditorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
            iEditorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(true));
            iEditorComponent.runAction((AbstractEditorAction)new RunFullLayoutAction());
        }
        catch (JDOMException jDOMException) {
            LOGGER.debug((Object)"JDOMException:", (Throwable)jDOMException);
            this.novaMindListener.importErrorOccurred(jDOMException.getMessage());
            throw new IllegalArgumentException("Exception occurred when parsing Document: " + file.getName(), jDOMException);
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)("IOException occurred when parsing Document: " + file.getName()), (Throwable)iOException);
            this.novaMindListener.importErrorOccurred(iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.debug((Object)"IllegalArgumentException:", (Throwable)illegalArgumentException);
            this.novaMindListener.importErrorOccurred(illegalArgumentException.getMessage());
        }
    }

    private void processNMMap(IEditorComponent iEditorComponent, Element element) {
        Element element2 = element.getChild(ROOT);
        Element element3 = element2.getChild(NMMAPBRANCH);
        this.initProgress(element3);
        this.parseNMMapBranchElement(element3, iEditorComponent);
        this.processLinkLines(element, iEditorComponent);
        this.processCellsWithBoundaries(iEditorComponent);
    }

    private void processCellsWithBoundaries(IEditorComponent iEditorComponent) {
        for (mmIStructureCell mmIStructureCell2 : this.cellsWithBoundaries) {
            List<mmIStructureCell> list = this.getBranchChildrenRecursive(mmIStructureCell2);
            iEditorComponent.runAction((AbstractEditorAction)new AddBoundaryAction(list.toArray(new mmIStructureCell[list.size()])));
        }
    }

    private List<mmIStructureCell> getBranchChildrenRecursive(mmIStructureCell mmIStructureCell2) {
        ArrayList<mmIStructureCell> arrayList = new ArrayList<mmIStructureCell>();
        arrayList.add(mmIStructureCell2);
        this.doGetChildrenRecursive(mmIStructureCell2, arrayList);
        ArrayList<mmIStructureCell> arrayList2 = new ArrayList<mmIStructureCell>();
        for (mmIStructureCell mmIStructureCell3 : arrayList) {
            if (!(mmIStructureCell3 instanceof mmBranchCell)) continue;
            arrayList2.add(mmIStructureCell3);
        }
        return arrayList2;
    }

    private void doGetChildrenRecursive(mmIStructureCell mmIStructureCell2, List<mmIStructureCell> list) {
        for (mmIStructureCell mmIStructureCell3 : mmIStructureCell2.getChildStructures()) {
            list.add(mmIStructureCell3);
            this.doGetChildrenRecursive(mmIStructureCell3, list);
        }
    }

    private void processLinkLines(Element element, IEditorComponent iEditorComponent) {
        Element element2 = element.getChild("linkLines");
        if (element2 == null) {
            return;
        }
        List list = element2.getChildren("linkLine");
        for (Element element3 : list) {
            Element element4 = element3.getChild(NMGRAPHIC);
            if (element4 == null) continue;
            Element element5 = element4.getChild("startGraphicNumber");
            Element element6 = element4.getChild("endGraphicNumber");
            if (element5 == null || element6 == null) continue;
            mmIStructureCell mmIStructureCell2 = this.graphicNumberToCellMap.get(element5.getText());
            mmIStructureCell mmIStructureCell3 = this.graphicNumberToCellMap.get(element6.getText());
            if (mmIStructureCell2 == null || mmIStructureCell3 == null) continue;
            iEditorComponent.runAction((AbstractEditorAction)new AddRelationshipAction(mmIStructureCell2, mmIStructureCell3));
        }
    }

    private void clearState() {
        this.parent = null;
        this.currentElement = new Element("central");
        this.isCentralIdea = true;
        this.progressCount = 0;
        this.currentProgress = 0;
        this.novaMindListener = null;
        this.graphicNumberToCellMap.clear();
        this.cellsWithBoundaries.clear();
    }

    private Element getNMMapElement(Element element) {
        Element element2 = element.getChild(MAPS);
        Element element3 = element2.getChild(MAP);
        return element3.getChild("NMMap");
    }

    private void importProgress() {
        ++this.currentProgress;
        float f = (float)this.currentProgress * 1.0f / (float)this.progressCount;
        f = Math.round(f * 100.0f);
        this.novaMindListener.importProgress(f);
    }

    private void parseNMMapBranchElement(Element element, IEditorComponent iEditorComponent) {
        this.currentElement = element;
        String string = this.processBranchText();
        if (string == null) {
            string = "";
        }
        if (this.isCentralIdea) {
            this.current = (mmIStructureCell)iEditorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(string));
            this.isCentralIdea = false;
        } else {
            this.current = (mmIStructureCell)iEditorComponent.runAction((AbstractEditorAction)new AddBranchAction(this.parent, BranchType.BRANCH, string));
        }
        this.processMainGraphic();
        this.processBranchImage();
        this.processOtherEnclosedGraphicsImage();
        this.processHyperlinks(iEditorComponent);
        this.processAttachedTextArray(iEditorComponent);
        this.processBoundaryElements();
        this.importProgress();
        Element element2 = this.currentElement.getChild(CHILDREN);
        if (element2 == null) {
            return;
        }
        List list = element2.getChildren(NMMAPBRANCH);
        mmIStructureCell mmIStructureCell2 = this.current;
        for (Element element3 : list) {
            this.parent = mmIStructureCell2;
            this.parseNMMapBranchElement(element3, iEditorComponent);
        }
    }

    private void processBoundaryElements() {
        Element element = this.currentElement.getChild("hasBoundary");
        if (element == null) {
            return;
        }
        String string = element.getText();
        if ("YES".equals(string)) {
            this.cellsWithBoundaries.add(this.current);
        }
    }

    private void processMainGraphic() {
        Element element = this.currentElement.getChild("mainGraphic");
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(NMGRAPHIC);
        if (element2 == null) {
            return;
        }
        Element element3 = element2.getChild("graphicNumber");
        if (element3 == null) {
            return;
        }
        String string = element3.getText();
        if (string == null) {
            return;
        }
        this.graphicNumberToCellMap.put(string, this.current);
    }

    private void processAttachedTextArray(IEditorComponent iEditorComponent) {
        Element element = this.currentElement.getChild(ATTACHED_TEXT_ARRAY);
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(ITEM);
        if (element2 == null) {
            return;
        }
        Element element3 = element2.getChild(NM_ATTACHED_TEXT);
        if (element3 == null) {
            return;
        }
        Element element4 = element3.getChild(TEXT);
        if (element4 == null) {
            return;
        }
        Element element5 = element4.getChild(NSATTRIBUTED_STRING);
        if (element5 == null) {
            return;
        }
        Element element6 = element5.getChild(STRING);
        if (element6 == null) {
            return;
        }
        Notes notes = new Notes();
        notes.setNotes(element6.getText());
        iEditorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.current, "com.thinkbuzan.gaia.cell.notes", (IProperty)notes));
    }

    private void processHyperlinks(IEditorComponent iEditorComponent) {
        Element element = this.currentElement.getChild(HYPERLINKS);
        if (element == null) {
            return;
        }
        List list = element.getChildren(HYPERLINK);
        for (Element element2 : list) {
            Element element3;
            Element element4 = element2.getChild(NMHYPERLINK);
            if (element4 == null || (element3 = element4.getChild(LINK_URL)) == null) continue;
            HyperLinkType hyperLinkType = this.processLinkType(element4.getChild(LINK_TYPE));
            ArrayList<HyperLink> arrayList = PropertyUtilities.getPropertyList((mmICell)this.current, (String)"com.thinkbuzan.gaia.cell.hyperlinks");
            if (arrayList == null) {
                arrayList = new ArrayList<HyperLink>();
            }
            HyperLink hyperLink = new HyperLink();
            hyperLink.setLink(element3.getText());
            hyperLink.setType(hyperLinkType);
            arrayList.add(hyperLink);
            iEditorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.current, "com.thinkbuzan.gaia.cell.hyperlinks", arrayList));
        }
    }

    private HyperLinkType processLinkType(Element element) {
        if (element != null) {
            String string = element.getText();
            if ("1".equals(string)) {
                return HyperLinkType.FILE;
            }
            if ("2".equals(string)) {
                return HyperLinkType.WEB;
            }
            if ("5".equals(string)) {
                return HyperLinkType.EMAIL;
            }
        }
        return HyperLinkType.WEB;
    }

    private void processOtherEnclosedGraphicsImage() {
        Element element = this.currentElement.getChild(OTHERENCLOSEDGRAPHICS);
        if (element == null) {
            return;
        }
        LOGGER.debug((Object)OTHERENCLOSEDGRAPHIC);
        Element element2 = element.getChild(OTHERENCLOSEDGRAPHIC);
        Element element3 = element2.getChild(NMENCLOSED_GRAPHIC);
        Element element4 = element3.getChild(GRAPHIC);
        Element element5 = element4.getChild(NMGRAPHIC);
        Element element6 = element5.getChild(BOUNDS);
        this.processBranchBounds(element6);
    }

    private void processBranchBounds(Element element) {
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(X);
        LOGGER.debug((Object)("X:" + element2.getText()));
        Element element3 = element.getChild(Y);
        LOGGER.debug((Object)("Y:" + element3.getText()));
        Element element4 = element.getChild(WIDTH);
        LOGGER.debug((Object)("WIDTH:" + element4.getText()));
        Element element5 = element.getChild(HEIGHT);
        LOGGER.debug((Object)("HEIGHT:" + element5.getText()));
    }

    private void processBranchImage() {
        Element element = this.currentElement.getChild(ENCLOSEDIMAGE);
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(NMGRAPHIC);
        Element element3 = element2.getChild(BOUNDS);
        this.processBranchBounds(element3);
    }

    private String processBranchText() {
        Element element = this.currentElement.getChild(ENCLOSEDTEXTAREA);
        Element element2 = element.getChild(NMGRAPHIC);
        if (element2 == null) {
            return null;
        }
        Element element3 = element2.getChild(TEXT);
        if (element3 == null) {
            return null;
        }
        Element element4 = element3.getChild(NSATTRIBUTED_STRING);
        if (element4 == null) {
            return null;
        }
        Element element5 = element4.getChild(STRING);
        String string = element5.getTextTrim();
        this.processColor(element4);
        this.processBranchTextFont(element4);
        Element element6 = element2.getChild(BOUNDS);
        this.processBranchBounds(element6);
        return string;
    }

    private void processBranchTextFont(Element element) {
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(FORMATTING);
        if (element2 == null) {
            return;
        }
        Element element3 = element2.getChild(NMWIN_FONT_ATTRIBUTE_NAME);
        if (element3 == null) {
            return;
        }
        Element element4 = element3.getChild(NMWIN_FONT);
        if (element4 == null) {
            return;
        }
        Element element5 = element4.getChild(NAME);
        Element element6 = element4.getChild(SIZE);
        Element element7 = element4.getChild(BOLD);
        Element element8 = element4.getChild(ITALIC);
        LOGGER.debug((Object)("FONT NAME:" + element5.getText()));
        LOGGER.debug((Object)("FONT SIZE:" + element6.getText()));
        LOGGER.debug((Object)("FONT BOLD:" + element7.getText()));
        LOGGER.debug((Object)("FONT ITALIC:" + element8.getText()));
    }

    private void processColor(Element element) {
        if (element == null) {
            return;
        }
        Element element2 = element.getChild(FORMATTING);
        if (element2 == null) {
            return;
        }
        Element element3 = element2.getChild(NSFOREGROUND_COLOR_ATTRIBUTE_NAME);
        if (element3 == null) {
            return;
        }
        Element element4 = element3.getChild(NSCOLOR);
        if (element4 == null) {
            return;
        }
        Element element5 = element4.getChild(RED);
        Element element6 = element4.getChild(GREEN);
        Element element7 = element4.getChild(BLUE);
        float f = Float.parseFloat(element5.getText());
        float f2 = Float.parseFloat(element6.getText());
        float f3 = Float.parseFloat(element7.getText());
        Color color = new Color(f, f2, f3);
        int n = color.getRed() * 256 * 256 + color.getGreen() * 256 + color.getBlue();
        LOGGER.debug((Object)("Color: #" + Integer.toHexString(n)));
    }

    private int getChildrenCount(Element element) {
        int n = 1;
        Element element2 = element.getChild(CHILDREN);
        if (element2 == null) {
            return n;
        }
        List list = element2.getChildren(NMMAPBRANCH);
        for (Element element3 : list) {
            n += this.getChildrenCount(element3);
        }
        return n;
    }

    private void parseMetaDataElement(Element element) {
        Element element2 = element.getChild(CREATION_DATE);
        Element element3 = element.getChild(LAST_SAVE_DATE);
        this.parseDate(element2, "CREATION");
        this.parseDate(element3, "SAVE");
    }

    private void parseDate(Element element, String string) {
        Element element2 = element.getChild(NSCALENDAR_DATE);
        String string2 = element2.getChildText(YEAR);
        String string3 = element2.getChildText(MONTH);
        String string4 = element2.getChildText(DAY);
        String string5 = element2.getChildText(HOUR);
        String string6 = element2.getChildText(MINUTE);
        String string7 = element2.getChildText(SECOND);
        String string8 = element2.getChildText(UTC);
        LOGGER.debug((Object)(string + " year:" + string2));
        LOGGER.debug((Object)(string + " month:" + string3));
        LOGGER.debug((Object)(string + " day:" + string4));
        LOGGER.debug((Object)(string + " hour:" + string5));
        LOGGER.debug((Object)(string + " minute:" + string6));
        LOGGER.debug((Object)(string + " second:" + string7));
        LOGGER.debug((Object)(string + " utc:" + string8));
    }

    private void validateImportFile(File file, IEditorComponent iEditorComponent, IImporterListener iImporterListener) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (iEditorComponent == null) {
            throw new IllegalArgumentException("IEditorComponent can not be null.");
        }
        if (iImporterListener == null) {
            throw new IllegalArgumentException("listener can not be null.");
        }
    }

    private void initProgress(Element element) {
        this.progressCount = 0;
        this.currentProgress = 0;
        this.progressCount = this.getChildrenCount(element);
    }

    public final Icon getIcon() {
        return new ImageIcon(ResourceManager.getResourceIcon24());
    }

    public final String getId() {
        return NovaMindImporter.class.getPackage().getName();
    }

    public final String getLabel() {
        return LABEL;
    }

    public List<String> getAllowedExtensions() {
        return EXTENSIONS;
    }

    public String getFileFilterDescription() {
        return this.description;
    }

    public boolean isVisible() {
        return true;
    }

    public String getCategory() {
        return "Mind Map";
    }
}

