/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.novamind.util;

import com.buzanonline.chaos.fileaccessservice2.FileAccessService2;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecompressFileUtil {
    private static final Logger LOG = Logger.getLogger(DecompressFileUtil.class);
    private static final String OUTPUT_PATH = FileAccessService2.getTemporaryDirectory().getAbsolutePath();
    private static final int BUFFER_SIZE = 8192;

    private DecompressFileUtil() {
    }

    private static void safeOutput(String string) {
        boolean bl;
        File file = new File(string);
        if (!file.exists() && !(bl = file.mkdirs())) {
            LOG.error((Object)"safeOutput() create outputPath error!");
        }
    }

    private static List<String> decompressTarFile(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DecompressFileUtil.safeOutput(OUTPUT_PATH);
            TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(file));
            TarArchiveEntry tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)tarArchiveInputStream);
            while (tarArchiveEntry != null) {
                String string = OUTPUT_PATH + File.separator + tarArchiveEntry.getName();
                arrayList.add(string);
                if (tarArchiveEntry.isDirectory()) {
                    tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
                    continue;
                }
                File file2 = new File(string);
                if (!file2.getParentFile().exists()) {
                    DecompressFileUtil.makeParentFile(file2);
                }
                byte[] byArray = new byte[8192];
                fileOutputStream = new FileOutputStream(string);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
                int n = bufferedInputStream.read(byArray, 0, 8192);
                while (n != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                    n = bufferedInputStream.read(byArray, 0, 8192);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                ((OutputStream)fileOutputStream).close();
                tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
            }
            bufferedInputStream.close();
        }
        catch (ZipException zipException) {
            LOG.error((Object)"zip exception:", (Throwable)zipException);
        }
        catch (IOException iOException) {
            LOG.error((Object)"I/O exception:", (Throwable)iOException);
        }
        return arrayList;
    }

    private static void makeParentFile(File file) {
        boolean bl = file.getParentFile().mkdirs();
        if (!bl) {
            LOG.error((Object)"makeParentFile() Creates the directory error!");
        }
    }

    private static List<String> decompressGzipFile(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DecompressFileUtil.safeOutput(OUTPUT_PATH);
            String string = OUTPUT_PATH + File.separator + file.getName();
            arrayList.add(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)fileInputStream);
            byte[] byArray = new byte[8192];
            int n = gzipCompressorInputStream.read(byArray);
            while (n != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                n = gzipCompressorInputStream.read(byArray);
            }
            ((OutputStream)fileOutputStream).close();
            gzipCompressorInputStream.close();
        }
        catch (ZipException zipException) {
            LOG.error((Object)"zip exception:", (Throwable)zipException);
        }
        catch (IOException iOException) {
            LOG.error((Object)"I/O exception:", (Throwable)iOException);
        }
        return arrayList;
    }

    public static File decompress(File file) {
        DecompressFileUtil.validateDecompress(file);
        List<String> list = DecompressFileUtil.decompressGzipFile(file);
        String string = list.get(0);
        List<String> list2 = DecompressFileUtil.decompressTarFile(new File(string));
        for (String string2 : list2) {
            if (!string2.contains("Contents.xml")) continue;
            return new File(string2);
        }
        return null;
    }

    private static void validateDecompress(File file) {
        if (file == null) {
            throw new IllegalArgumentException("compressFile can't be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("compressFile is not exit.");
        }
    }
}

