/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.datamodel;

import com.kitfox.svg.SVGDiagram;
import com.thinkbuzan.apollo.iconlibrary.icons.ResourceManager;
import com.thinkbuzan.apollo.ui.core.GraphicsConf;
import com.thinkbuzan.gaia.iconlibrary.datamodel.Category;
import com.thinkbuzan.gaia.iconlibrary.svg.FileLoader;
import com.thinkbuzan.gaia.iconlibrary.svg.Painter;
import com.thinkbuzan.gaia.iconlibrary.svg.style.SVGStyle;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class CachedIcon {
    private static final String SVG_POSTFIX = ".svg";
    private final transient String id;
    private transient String legacyId;
    private transient String fileName;
    private transient BufferedImage image;
    private transient Category category;
    private transient boolean legacy;
    private transient boolean userDefined;
    private transient boolean processed = true;
    private transient String svgFileName;
    private HashMap<Integer, BufferedImage> cache;
    private SVGDiagram loadedSvgDiagram = null;
    private transient BufferedImage retinaImage;
    private static final int STEP_ONE = 16;
    private static final int STEP_TWO = 32;
    private static final int STEP_THREE = 64;
    private static final int STEP_FOUR = 128;
    private static final int STEP_FIVE = 256;

    public CachedIcon(String idIn) {
        this.id = idIn;
        this.cache = new HashMap();
    }

    public final String getId() {
        return this.id;
    }

    public final String getLegacyId() {
        return this.legacyId;
    }

    public final void setLegacyId(String value) {
        this.legacyId = value;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(String fileNameIn) {
        this.fileName = fileNameIn;
        if (this.fileName.endsWith(".png")) {
            this.svgFileName = this.fileName.substring(0, this.fileName.length() - SVG_POSTFIX.length()) + SVG_POSTFIX;
        }
    }

    public final BufferedImage getImage() {
        if (this.image == null && this.retinaImage != null) {
            return this.retinaImage;
        }
        return this.image;
    }

    public final BufferedImage getRetinaImage() {
        if (this.retinaImage == null) {
            return this.getImage();
        }
        return this.retinaImage;
    }

    private final boolean isRetina(Component c) {
        return GraphicsConf.isRetina((Component)c);
    }

    public final BufferedImage getImage(int w, int h) {
        boolean isRetinaDevice = this.isRetina(MainFrameUtilities.getMainFrame());
        float scale = 1.0f;
        int dimensionForRequest = w;
        if (isRetinaDevice) {
            scale = 0.5f;
            dimensionForRequest *= 2;
        }
        Dimension dimensionToUse = this.getImageSizeForRequestedDimension(dimensionForRequest);
        int width = dimensionToUse.width;
        int height = dimensionToUse.height;
        BufferedImage cached = this.cache.get(width);
        if (cached != null) {
            return cached;
        }
        if (this.loadedSvgDiagram == null) {
            try {
                String id = this.getId();
                String packageName = id.substring(0, id.lastIndexOf(46));
                packageName = packageName.substring(packageName.lastIndexOf(46) + 1, packageName.length());
                String name = packageName + "/" + this.svgFileName;
                InputStream svgFileInputStream = ResourceManager.getStreamByName(name);
                this.loadedSvgDiagram = FileLoader.getSVGDiagramFromInputStream(svgFileInputStream, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.loadedSvgDiagram != null) {
            ArrayList<SVGStyle> styles = new ArrayList<SVGStyle>();
            float scaleWidth = (float)width / this.loadedSvgDiagram.getWidth();
            float scaleHeight = (float)height / this.loadedSvgDiagram.getHeight();
            Painter p = new Painter(this.loadedSvgDiagram, styles, new AffineTransform(scaleWidth, 0.0f, 0.0f, scaleHeight, 0.0f, 0.0f));
            BufferedImage ideaImage = new BufferedImage(width, height, 3);
            Graphics2D g2d = (Graphics2D)ideaImage.createGraphics().create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.scale(scale, scale);
            p.doDraw(g2d);
            this.cache.put(width, ideaImage);
            return ideaImage;
        }
        BufferedImage originalBufferedImage = this.getImage();
        this.cache.put(width, originalBufferedImage);
        return originalBufferedImage;
    }

    private final Dimension getImageSizeForRequestedDimension(int dimension) {
        if (dimension >= 128) {
            return new Dimension(256, 256);
        }
        if (dimension >= 64) {
            return new Dimension(128, 128);
        }
        if (dimension >= 32) {
            return new Dimension(64, 64);
        }
        if (dimension >= 16) {
            return new Dimension(32, 32);
        }
        return new Dimension(16, 16);
    }

    public final void setImage(BufferedImage imageIn) {
        this.image = imageIn;
    }

    public final void setRetinaImage(BufferedImage imageIn) {
        this.retinaImage = imageIn;
    }

    public final void setCategory(Category catIn) {
        this.category = catIn;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final boolean equals(Object matchIcon) {
        if (matchIcon instanceof CachedIcon) {
            if (this.id.equals(((CachedIcon)matchIcon).getId())) {
                return true;
            }
            return this.legacyId != null && this.legacyId.equals(((CachedIcon)matchIcon).getId());
        }
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean isLegacy() {
        return this.legacy;
    }

    public final void setLegacy(boolean legacyIn) {
        this.legacy = legacyIn;
    }

    public final boolean isUserDefined() {
        return this.userDefined;
    }

    public final void setUserDefined(boolean isUserDefined) {
        this.userDefined = isUserDefined;
    }

    public final boolean isProcessed() {
        return this.processed;
    }

    public final void setProcessed(boolean isProcessed) {
        this.processed = isProcessed;
    }
}

