/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.datamodel;

import com.thinkbuzan.gaia.iconlibrary.datamodel.CachedIconConstants;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;

public final class CachedIconIDTransferable
implements Transferable,
Serializable {
    private static final long serialVersionUID = 2078280802794253077L;
    private final String iconID;
    private final String draggedOffID;

    public CachedIconIDTransferable(String iconIDIn) {
        this(iconIDIn, null);
    }

    public CachedIconIDTransferable(String iconIDIn, String draggedOffIDIn) {
        if (iconIDIn == null) {
            throw new IllegalArgumentException("iconIDIn cannot be null!");
        }
        this.iconID = iconIDIn;
        this.draggedOffID = draggedOffIDIn;
    }

    public String getIconID() {
        return this.iconID;
    }

    public String getDraggedOffCellID() {
        return this.draggedOffID;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CachedIconConstants.DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return CachedIconConstants.DATA_FLAVOR == flavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        CachedIconIDTransferable theID = null;
        if (this.isDataFlavorSupported(flavor)) {
            theID = this;
        }
        return theID;
    }
}

