/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.impl;

import com.thinkbuzan.gaia.iconlibrary.IconManager;
import com.thinkbuzan.gaia.iconlibrary.datamodel.CachedIcon;
import com.thinkbuzan.gaia.iconlibrary.datamodel.Category;
import com.thinkbuzan.gaia.iconlibrary.xml.IconLibraryXMLParser;
import com.thinkbuzan.gaia.iconlibrary.xml.IconResourcesManager;
import com.thinkbuzan.gaia.iconlibrary.xml.IconXMLCodec;
import com.thinkbuzan.gaia.iconlibrary.xml.IconXMLLoader;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class IconManagerImpl
implements IconManager {
    private static final Logger LOGGER = Logger.getLogger(IconManagerImpl.class);
    private static final String CURRENT_VERSION = "1.0";
    private static final String DATA = "data";
    private final transient Map<String, CachedIcon> iconIdToIcon = new HashMap<String, CachedIcon>();
    private final transient File userIconFile;
    private final transient File userIconDataFolder;
    private final transient IconXMLCodec iconsCodec;

    public IconManagerImpl(File iconsFile) {
        this.userIconFile = iconsFile;
        this.userIconDataFolder = new File(iconsFile.getParentFile() + File.separator + DATA);
        this.iconsCodec = new IconXMLCodec();
    }

    @Override
    public final List<Category> getIconCategorys() {
        return Collections.unmodifiableList(IconLibraryXMLParser.getIconLib().getCategories());
    }

    @Override
    public final CachedIcon getIcon(String id) {
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("The id cannot be null or empty");
        }
        if (this.iconIdToIcon.isEmpty() || !this.iconIdToIcon.containsKey(id)) {
            CachedIcon matchIcon = new CachedIcon(id);
            for (CachedIcon icon : IconLibraryXMLParser.getIconLib().getCachedIcons()) {
                if (!icon.equals(matchIcon)) continue;
                return icon;
            }
            List<Category> legacyCategories = this.getLegacyIconCategorys();
            for (Category category : legacyCategories) {
                if (!category.getCachedIcons().contains(matchIcon)) continue;
                CachedIcon targetIcon = category.getCachedIcons().get(category.getCachedIcons().indexOf(matchIcon));
                this.iconIdToIcon.put(id, targetIcon);
                return targetIcon;
            }
            List<Category> userCats = this.iconsCodec.getCategoryList();
            for (Category category : userCats) {
                if (!category.getCachedIcons().contains(matchIcon)) continue;
                CachedIcon targetIcon = category.getCachedIcons().get(category.getCachedIcons().indexOf(matchIcon));
                this.iconIdToIcon.put(id, targetIcon);
                return targetIcon;
            }
        } else {
            return this.iconIdToIcon.get(id);
        }
        return null;
    }

    @Override
    public final List<Category> getLegacyIconCategorys() {
        return Collections.unmodifiableList(IconLibraryXMLParser.getLegacyIconLib().getCategories());
    }

    @Override
    public final List<Category> getUserIconCategorys() {
        if (!this.userIconDataFolder.exists()) {
            this.userIconDataFolder.mkdirs();
        }
        if (this.iconsCodec.getCategoryList() == null) {
            this.initFile();
        }
        if (this.userIconFile.exists() && this.iconsCodec.getCategoryList() != null) {
            return this.iconsCodec.getCategoryList();
        }
        return new ArrayList<Category>();
    }

    private void initFile() {
        this.createIconFile();
        IconXMLLoader themLoader = new IconXMLLoader();
        Document doc = themLoader.getDocument(this.userIconFile);
        String localVersion = this.iconsCodec.decodeVersionOnly(doc);
        if (!localVersion.equalsIgnoreCase(CURRENT_VERSION)) {
            this.updateIconsFile();
        }
        this.loadModelFromFile();
    }

    private void createIconFile() {
        if (!this.userIconFile.getParentFile().exists() && !this.userIconFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Could not create icons dir " + this.userIconFile.getParentFile());
        }
        if (!this.userIconFile.exists()) {
            this.updateIconsFile();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Created icons file successfully");
        }
    }

    private void updateIconsFile() {
        String fileName = "icons.xml";
        try {
            this.writeInputToOutputStream(IconResourcesManager.getResourceAsStream("icons.xml"), new FileOutputStream(this.userIconFile));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not create icon file " + this.userIconFile, ex);
        }
    }

    private void writeInputToOutputStream(InputStream inStream, OutputStream outStream) throws IOException {
        for (int count = 1; count <= 2; ++count) {
            try {
                IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
                IOUtils.closeQuietly((InputStream)inStream);
                IOUtils.closeQuietly((OutputStream)outStream);
                break;
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)("Attempt " + count + ": couldn't write output stream" + outStream));
                if (count != 2) continue;
                LOGGER.error((Object)"Couldn't write output stream after 2 attempts.", (Throwable)ioe);
                throw ioe;
            }
        }
    }

    private void updateIconsXMLFile() {
        Element iconsXML = this.iconsCodec.encode(CURRENT_VERSION);
        try {
            FileOutputStream outStream = new FileOutputStream(this.userIconFile);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(iconsXML, (OutputStream)outStream);
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not store updated tags file " + this.userIconFile, ex);
        }
    }

    private void loadModelFromFile() {
        IconXMLLoader iconLoader = new IconXMLLoader();
        Document doc = iconLoader.getDocument(this.userIconFile);
        if (iconLoader.getValidateStatus() != 0 && iconLoader.getValidateStatus() != 1 && iconLoader.getValidateException() != null) {
            LOGGER.error((Object)"iconLoader.getValidateException() is not null", (Throwable)iconLoader.getValidateException());
        }
        this.iconsCodec.decode(doc, this.userIconDataFolder);
    }

    @Override
    public void addUserCategory(Category category) {
        this.iconsCodec.addCategory(category);
        this.updateIconsXMLFile();
    }

    @Override
    public void removeUserCategory(Category category) {
        this.iconsCodec.removeCategory(category);
        this.updateIconsXMLFile();
    }

    @Override
    public void addUserIcon(CachedIcon icon) {
        UUID targetCatId = icon.getCategory().getId();
        this.ensureImageAvailable(icon);
        if (icon.getCategory().isUserDefined()) {
            List<Category> cats = this.iconsCodec.getCategoryList();
            for (Category cat : cats) {
                if (!cat.getId().equals(targetCatId)) continue;
                cat.addCachedIcon(icon);
            }
        } else {
            if (!this.iconsCodec.getCategoryList().contains(icon.getCategory())) {
                this.iconsCodec.addCategory(icon.getCategory());
            }
            icon.getCategory().addCachedIcon(icon);
        }
        this.updateIconsXMLFile();
    }

    @Override
    public void removeUserIcon(CachedIcon icon) {
        UUID targetCatId = icon.getCategory().getId();
        List<Category> cats = this.iconsCodec.getCategoryList();
        ArrayList<Category> update = new ArrayList<Category>();
        for (Category cat : cats) {
            if (!cat.getId().equals(targetCatId)) continue;
            cat.removeCachedIcon(icon);
            if (update.contains(cat)) continue;
            update.add(cat);
        }
        for (Category cat : update) {
            this.iconsCodec.removeCategory(cat);
            this.iconsCodec.addCategory(cat);
        }
        this.updateIconsXMLFile();
    }

    private void ensureImageAvailable(CachedIcon icon) {
        if (icon.getFileName() == null) {
            if (this.userIconDataFolder.exists()) {
                for (File file : this.userIconDataFolder.listFiles()) {
                    if (!file.getName().equalsIgnoreCase(icon.getId())) continue;
                    icon.setFileName(file.getName());
                    break;
                }
                if (icon.getFileName() == null) {
                    this.writeImageToFile(icon);
                }
            } else {
                this.writeImageToFile(icon);
            }
        } else {
            LOGGER.warn((Object)"Icon file name is null");
        }
    }

    private void writeImageToFile(CachedIcon icon) {
        try {
            ImageIO.write((RenderedImage)icon.getImage(), "PNG", new File(this.userIconDataFolder + File.separator + icon.getId()));
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Fail", (Throwable)e);
        }
        icon.setFileName(icon.getId());
    }

    @Override
    public void addTemporaryIcon(CachedIcon local) {
        this.iconIdToIcon.put(local.getId(), local);
    }
}

