/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.osgi;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.iconlibrary.IconManager;
import com.thinkbuzan.gaia.iconlibrary.impl.IconManagerImpl;
import com.thinkbuzan.gaia.iconlibrary.osgi.I18nService;
import java.io.File;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String PROPERTY_BASE_NAME = "/i18nproperties/Gaia_IconLibraryServiceMessages";
    private static final transient String ICONS_PATH = "icons";
    private static final transient String ICONS_XML = "user_icons.xml";

    public final void start(BundleContext context) {
        OSGiService i18nService = new OSGiService(context, I18n.class);
        I18nService.setI18n((I18n)i18nService.get());
        ((I18n)i18nService.get()).register(new ITextBundle(){

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return Activator.PROPERTY_BASE_NAME;
            }
        });
        i18nService.close();
        this.registerIconManager(context);
    }

    private void registerIconManager(BundleContext context) {
        OSGiService fileAccessServiceReference = new OSGiService(context, FileAccessService.class);
        FileAccessService fileAccessService = (FileAccessService)fileAccessServiceReference.get();
        File themeFile = fileAccessService.getUserFile(ICONS_PATH + File.separator + ICONS_XML);
        IconManagerImpl iconManager = new IconManagerImpl(themeFile);
        context.registerService(IconManager.class.getName(), (Object)iconManager, null);
        fileAccessServiceReference.close();
    }

    public void stop(BundleContext context) {
    }
}

