/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.thinkbuzan.gaia.iconlibrary.svg.style.SVGStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class Painter
extends Component {
    private SVGDiagram svgDiagram;
    private ArrayList<SVGStyle> svgStyles;
    private AffineTransform transform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);

    public Painter(SVGDiagram diagram, ArrayList<SVGStyle> styles) {
        this.svgDiagram = diagram;
        this.svgStyles = styles;
        for (SVGStyle style : this.svgStyles) {
            this.setStyleOnDiagram(style);
        }
    }

    public Painter(SVGDiagram diagram, ArrayList<SVGStyle> styles, AffineTransform transform) {
        this(diagram, styles);
        this.transform = transform;
    }

    public void setStyle(SVGStyle style) {
        this.setStyleOnDiagram(style);
        this.repaint();
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
        this.repaint();
    }

    public void doDraw(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setTransform(this.transform);
        try {
            this.svgDiagram.render(g2d);
        }
        catch (SVGException exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setTransform(this.transform);
        try {
            this.svgDiagram.render(g2d);
        }
        catch (SVGException exc) {
            exc.printStackTrace();
        }
    }

    private void setStyleOnDiagram(SVGStyle style) {
        try {
            if (this.svgDiagram.getRoot().hasAttribute(style.getName(), 0)) {
                this.svgDiagram.getRoot().setAttribute(style.getName(), 0, style.getValue());
            } else {
                this.svgDiagram.getRoot().addAttribute(style.getName(), 0, style.getValue());
            }
        }
        catch (SVGElementException e) {
            e.printStackTrace();
        }
    }
}

