/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.utils;

import com.thinkbuzan.gaia.iconlibrary.datamodel.CachedIcon;
import com.thinkbuzan.gaia.iconlibrary.icons.ResourceManager;
import com.thinkbuzan.gaia.iconlibrary.utils.IconConstants;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.ico.ICODecoder;
import org.apache.log4j.Logger;

public final class IconUtils {
    private static final Logger LOG = Logger.getLogger(IconUtils.class);
    private static final String DOT = ".";
    private static final String RETINA = "@2x.";

    private IconUtils() {
    }

    public static BufferedImage convert(CachedIcon icon) {
        IconUtils.validataConvert(icon);
        if (icon.getFileName().contains("green")) {
            icon.toString();
        }
        InputStream inputStream = com.thinkbuzan.apollo.iconlibrary.icons.ResourceManager.getStreamByName(IconUtils.getIconNameIncludePackage(icon));
        return IconUtils.convert(inputStream);
    }

    public static BufferedImage convertRetina(CachedIcon icon) {
        IconUtils.validataConvert(icon);
        String iconPathName = IconUtils.getIconNameIncludePackage(icon);
        String retinaIconPathName = iconPathName.replace(DOT, RETINA);
        InputStream inputStream = com.thinkbuzan.apollo.iconlibrary.icons.ResourceManager.getStreamByName(retinaIconPathName);
        return IconUtils.convert(inputStream, true);
    }

    public static BufferedImage convertLegacy(CachedIcon icon) {
        IconUtils.validataConvert(icon);
        InputStream inputStream = ResourceManager.getStreamByName(IconUtils.getIconNameIncludePackage(icon));
        return IconUtils.convert(inputStream);
    }

    public static BufferedImage convertUser(CachedIcon icon, File imageDatafolder) {
        IconUtils.validataConvert(icon);
        BufferedImage image = null;
        File file = new File(imageDatafolder.getAbsolutePath() + File.separator + icon.getFileName());
        try (FileInputStream inputStream = new FileInputStream(file);){
            image = IconUtils.convert(inputStream);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to read user icon " + icon.getFileName()), (Throwable)ex);
        }
        return image;
    }

    private static void validataConvert(CachedIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("CachedIcon can't be null");
        }
    }

    public static BufferedImage convert(InputStream inputStream) {
        return IconUtils.convert(inputStream, false);
    }

    public static BufferedImage convert(InputStream inputStream, boolean retina) {
        return IconUtils.convert(inputStream, retina, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convert(InputStream inputStream, boolean retina, String fileName) {
        IconUtils.validataConvert(inputStream);
        BufferedImage bufferedImage = null;
        try {
            int w = IconConstants.getCachedIconWidth();
            int h = IconConstants.getCachedIconHeight();
            if (retina) {
                w *= 2;
                h *= 2;
            }
            if (fileName == null) {
                bufferedImage = ImageIO.read(inputStream);
            } else if (fileName.toLowerCase(Locale.getDefault()).endsWith(".ico")) {
                List images = ICODecoder.read((InputStream)inputStream);
                int nearest = Short.MAX_VALUE;
                for (BufferedImage image : images) {
                    if (image.getWidth() - w <= 0 || image.getWidth() - w >= nearest) continue;
                    nearest = image.getWidth() - w;
                    bufferedImage = image;
                }
                if (bufferedImage == null && images.size() > 0) {
                    bufferedImage = (BufferedImage)images.get(images.size() - 1);
                }
            } else {
                bufferedImage = fileName.toLowerCase(Locale.getDefault()).endsWith(".bmp") ? BMPDecoder.read((InputStream)inputStream) : ImageIO.read(inputStream);
            }
            BufferedImage bufferedImage2 = IconUtils.scaleToSize(bufferedImage, w, h);
            return bufferedImage2;
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
        return bufferedImage;
    }

    private static void validataConvert(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null");
        }
    }

    private static BufferedImage scaleToSize(BufferedImage bufferedImageIn, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D tempGraphics = scaledImage.createGraphics();
        tempGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        tempGraphics.drawImage(bufferedImageIn, 0, 0, width, height, null);
        tempGraphics.dispose();
        return scaledImage;
    }

    public static String getIconNameIncludePackage(CachedIcon cachedIcon) {
        IconUtils.validataGetIconPath(cachedIcon);
        if (cachedIcon.isUserDefined()) {
            return cachedIcon.getFileName();
        }
        String id = cachedIcon.getId();
        String packageName = id.substring(0, id.lastIndexOf(46));
        packageName = packageName.substring(packageName.lastIndexOf(46) + 1, packageName.length());
        return packageName + "/" + cachedIcon.getFileName();
    }

    private static void validataGetIconPath(CachedIcon cachedIcon) {
        if (cachedIcon == null) {
            throw new IllegalArgumentException("CachedIcon can't be null");
        }
    }

    public static BufferedImage getIconBufferedImage(String iconName) {
        IconUtils.validataGetIconBufferedImage(iconName);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(com.thinkbuzan.apollo.iconlibrary.icons.ResourceManager.getStreamByName(iconName));
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
        }
        return bufferedImage;
    }

    private static void validataGetIconBufferedImage(String iconName) {
        if (iconName == null) {
            throw new IllegalArgumentException("iconName can't be null");
        }
    }
}

