/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.xml;

import com.thinkbuzan.gaia.iconlibrary.datamodel.CachedIcon;
import com.thinkbuzan.gaia.iconlibrary.datamodel.Category;
import com.thinkbuzan.gaia.iconlibrary.datamodel.IconLib;
import com.thinkbuzan.gaia.iconlibrary.osgi.I18nService;
import com.thinkbuzan.gaia.iconlibrary.utils.IconUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IconLibraryXMLHandler
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(IconLibraryXMLHandler.class);
    private static final String ICONS = "icons";
    private static final String CATEGORIES = "categories";
    private static final String ICON = "icon";
    private static final String CATEGORY = "category";
    private static final String ICONID = "iconid";
    private transient IconLib iconLib;
    private final transient Map<String, CachedIcon> iconMap = new HashMap<String, CachedIcon>();
    private transient Category tempCategory = null;
    private final transient boolean legacyHandler;

    public IconLibraryXMLHandler(boolean legacy) {
        this.legacyHandler = legacy;
    }

    public final IconLib getIconLib() {
        return this.iconLib;
    }

    @Override
    public final void startDocument() throws SAXException {
        this.iconLib = new IconLib();
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(ICON)) {
            this.processIcon(attributes);
        } else if (qName.equalsIgnoreCase(CATEGORY)) {
            this.processCategory(attributes);
        } else if (qName.equalsIgnoreCase(ICONID)) {
            this.processIconId(attributes);
        } else if (qName.equalsIgnoreCase(ICONS)) {
            this.iconLib.setCachedIcons(new ArrayList<CachedIcon>());
        } else if (qName.equalsIgnoreCase(CATEGORIES)) {
            this.iconLib.setCategories(new ArrayList<Category>());
        }
    }

    private void processIconId(Attributes attributes) {
        String id = attributes.getValue("id");
        if (id != null && this.iconMap.containsKey(id)) {
            CachedIcon tempIcon = this.iconMap.get(attributes.getValue("id"));
            this.tempCategory.getCachedIcons().add(tempIcon);
            tempIcon.setCategory(this.tempCategory);
        } else {
            LOGGER.error((Object)"Problem parsing the icon XML -- one of the ids was null or did not exist in the icon map");
        }
    }

    private void processCategory(Attributes attributes) {
        Category category = new Category();
        category.setCategoryName(I18nService.getLocalizedText(attributes.getValue("name")));
        category.setId(UUID.fromString(attributes.getValue("id")));
        category.setGroup(Boolean.parseBoolean(attributes.getValue("group")));
        category.setCachedIcons(new ArrayList<CachedIcon>());
        this.iconLib.getCategories().add(category);
        this.tempCategory = category;
    }

    private void processIcon(Attributes attributes) {
        if (attributes.getValue("id") != null) {
            BufferedImage image;
            String id = attributes.getValue("id");
            CachedIcon icon = new CachedIcon(id);
            icon.setFileName(attributes.getValue("filename"));
            icon.setLegacy(this.legacyHandler);
            BufferedImage retinaImage = null;
            if (this.legacyHandler) {
                image = IconUtils.convertLegacy(icon);
            } else {
                image = IconUtils.convert(icon);
                retinaImage = IconUtils.convertRetina(icon);
            }
            icon.setImage(image);
            if (retinaImage != null) {
                icon.setRetinaImage(retinaImage);
            }
            if (attributes.getValue("legacy") != null) {
                icon.setLegacyId(attributes.getValue("legacy"));
            }
            this.iconMap.put(icon.getId(), icon);
            this.iconLib.getCachedIcons().add(icon);
        } else {
            LOGGER.error((Object)"Problem parsing the icon XML -- one of the ids was null");
        }
    }
}

