/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.xml;

import com.thinkbuzan.gaia.iconlibrary.datamodel.IconLib;
import com.thinkbuzan.gaia.iconlibrary.icons.ResourceManager;
import com.thinkbuzan.gaia.iconlibrary.xml.IconLibraryXMLHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class IconLibraryXMLParser {
    private static final Logger LOG = Logger.getLogger(IconLibraryXMLParser.class);
    private static final IconLibraryXMLHandler HANDLER = new IconLibraryXMLHandler(false);
    private static final IconLibraryXMLHandler LEGACY_HANDLER = new IconLibraryXMLHandler(true);

    private IconLibraryXMLParser() {
    }

    public static IconLib getIconLib() {
        if (HANDLER.getIconLib() == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputStream inputStream = null;
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(HANDLER);
                inputStream = com.thinkbuzan.apollo.iconlibrary.icons.ResourceManager.getStreamByName("ApolloIconLibrary.xml");
                InputSource source = new InputSource(inputStream);
                reader.parse(source);
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)"ParserConfigurationException", (Throwable)e);
            }
            catch (SAXException e) {
                LOG.error((Object)"SAXException", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
        return HANDLER.getIconLib();
    }

    public static IconLib getLegacyIconLib() {
        if (LEGACY_HANDLER.getIconLib() == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputStream inputStream = null;
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(LEGACY_HANDLER);
                inputStream = ResourceManager.getStreamByName("IconLibrary.xml");
                InputSource source = new InputSource(inputStream);
                reader.parse(source);
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)"ParserConfigurationException", (Throwable)e);
            }
            catch (SAXException e) {
                LOG.error((Object)"SAXException", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
        return LEGACY_HANDLER.getIconLib();
    }
}

