/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.xml;

import com.thinkbuzan.gaia.iconlibrary.datamodel.CachedIcon;
import com.thinkbuzan.gaia.iconlibrary.datamodel.Category;
import com.thinkbuzan.gaia.iconlibrary.utils.IconUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class IconXMLCodec {
    private static final transient Logger LOGGER = Logger.getLogger(IconXMLCodec.class);
    public static final String ICONS_ROOT = "IconLibrary";
    private static final String NAMESPACE_URL = "http://www.thinkbuzan.org/IconSchema";
    private static final String CATEGORIES = "categories";
    private static final String CATEGORY = "category";
    private static final String ICONS = "icons";
    private static final String ICON = "icon";
    private static final String ID = "id";
    private static final String ICON_ID = "iconid";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String USER = "user";
    private static final String FILENAME = "filename";
    private static final String ICONS_VERSION = "IconVersion";
    private static final String LEGACY_VERSION = "1.0";
    private transient List<Category> categoryList;
    private transient String iconsVersion;
    private final transient Element iconLibraryElement;
    private final transient Namespace ns1 = Namespace.getNamespace((String)"http://www.thinkbuzan.org/IconSchema");

    public IconXMLCodec() {
        this.iconLibraryElement = new Element(ICONS_ROOT, this.ns1);
    }

    public final Element encode(String currentVersion) {
        this.iconLibraryElement.removeContent();
        this.iconLibraryElement.setAttribute(ICONS_VERSION, currentVersion);
        this.addCategories(Collections.unmodifiableList(this.categoryList));
        return this.iconLibraryElement;
    }

    private void addCategories(List<Category> categories) {
        Element iconListElement = new Element(ICONS, this.ns1);
        Element catListElement = new Element(CATEGORIES, this.ns1);
        for (Category category : categories) {
            Element catElem = new Element(CATEGORY, this.ns1);
            catElem.setAttribute(ID, category.getId().toString());
            catElem.setAttribute(GROUP, String.valueOf(true));
            catElem.setAttribute(NAME, category.getCategoryName());
            catElem.setAttribute(USER, String.valueOf(category.isUserDefined()));
            for (CachedIcon icon : category.getCachedIcons()) {
                if (!icon.isUserDefined()) continue;
                Element iconElement = new Element(ICON, this.ns1);
                iconElement.setAttribute(ID, icon.getId());
                iconElement.setAttribute(FILENAME, icon.getFileName());
                iconElement.setAttribute(USER, String.valueOf(icon.isUserDefined()));
                Element iconIdElement = new Element(ICON_ID, this.ns1);
                iconIdElement.setAttribute(ID, icon.getId());
                iconListElement.addContent((Content)iconElement);
                catElem.addContent((Content)iconIdElement);
            }
            catListElement.addContent((Content)catElem);
        }
        this.iconLibraryElement.addContent((Content)iconListElement);
        this.iconLibraryElement.addContent((Content)catListElement);
    }

    public final String decodeVersionOnly(Document document) {
        Element root = document.getRootElement();
        Attribute version = root.getAttribute(ICONS_VERSION);
        if (version != null) {
            return version.getValue();
        }
        return LEGACY_VERSION;
    }

    public final void decode(Document document, File imageDatafolder) {
        this.validateConvertIcons(document);
        Element root = document.getRootElement();
        this.categoryList = this.generateCategoriesAndTags(root, imageDatafolder);
        this.iconsVersion = this.decodeVersionOnly(document);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"After decoding we have:");
            LOGGER.debug((Object)String.format("icons=%s", this.categoryList));
        }
    }

    private void validateConvertIcons(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("IconLibrary doucument can't been null");
        }
    }

    private List<Category> generateCategoriesAndTags(Element tagsElementIn, File imageDatafolder) {
        HashMap<String, CachedIcon> localIconsList = new HashMap<String, CachedIcon>();
        Element iconsElement = tagsElementIn.getChild(ICONS, this.ns1);
        List iconElements = iconsElement.getChildren(ICON, this.ns1);
        for (Element iconElement : iconElements) {
            CachedIcon icon = this.processIcon(iconElement, imageDatafolder);
            localIconsList.put(icon.getId(), icon);
        }
        ArrayList<Category> localCategoryList = new ArrayList<Category>();
        Element tagsElement = tagsElementIn.getChild(CATEGORIES, this.ns1);
        List tagElements = tagsElement.getChildren(CATEGORY, this.ns1);
        for (Element tagElement : tagElements) {
            localCategoryList.add(this.processCategory(tagElement, localIconsList));
        }
        return localCategoryList;
    }

    private Category processCategory(Element element, Map<String, CachedIcon> localIconsList) {
        Category category = new Category();
        category.setCategoryName(element.getAttributeValue(NAME));
        category.setId(UUID.fromString(element.getAttributeValue(ID)));
        category.setUserDefined(Boolean.valueOf(element.getAttributeValue(USER)));
        ArrayList<CachedIcon> icons = new ArrayList<CachedIcon>();
        for (Object child : element.getChildren(ICON_ID, this.ns1)) {
            if (!(child instanceof Element)) continue;
            String id = ((Element)child).getAttributeValue(ID);
            if (localIconsList.containsKey(id)) {
                CachedIcon icon = localIconsList.get(id);
                icon.setCategory(category);
                icons.add(icon);
                continue;
            }
            LOGGER.warn((Object)("Missing icon id reference " + id));
        }
        category.setCachedIcons(icons);
        return category;
    }

    private CachedIcon processIcon(Element element, File imageDatafolder) {
        CachedIcon icon = null;
        if (element.getAttributeValue(ID) != null) {
            String id = element.getAttributeValue(ID);
            icon = new CachedIcon(id);
            icon.setFileName(element.getAttributeValue(FILENAME));
            icon.setLegacy(false);
            icon.setUserDefined(Boolean.valueOf(element.getAttributeValue(USER)));
            BufferedImage image = IconUtils.convertUser(icon, imageDatafolder);
            icon.setImage(image);
        } else {
            LOGGER.error((Object)"Problem parsing the icon XML -- one of the ids was null");
        }
        return icon;
    }

    public final List<Category> getCategoryList() {
        if (this.categoryList != null) {
            return Collections.unmodifiableList(this.categoryList);
        }
        return null;
    }

    public final String getIconVersion() {
        return this.iconsVersion;
    }

    public final void addCategory(Category categoryIn) {
        this.categoryList.add(categoryIn);
    }

    public final void removeCategory(Category categoryIn) {
        this.categoryList.remove(categoryIn);
    }
}

