/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.iconlibrary.xml;

import com.thinkbuzan.gaia.iconlibrary.xml.IconResourcesManager;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class IconXMLLoader {
    public static final int VALIDATE_PASS = 0;
    public static final int VALIDATE_WARNING = 1;
    public static final int VALIDATE_ERROR = 2;
    public static final int VALIDATE_FATAL_ERROR = 3;
    public static final Logger LOG = Logger.getLogger(IconXMLLoader.class);
    private static final transient String ICON_NAMESPACE = "http://www.thinkbuzan.org/IconSchema";
    private static final transient String SCHEMA_CHECK_FEATURE = "http://apache.org/xml/features/validation/schema";
    private static final transient String SCHEMA_FULL_CHECK_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final transient String SCHEMA_LOCATION_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private transient int validateStatus = 0;
    private transient SAXParseException validateException = null;

    public final Document getDocument(File iconXMLFile) {
        this.validateGetDocument(iconXMLFile);
        Document doc = null;
        try {
            this.initValidateStatus();
            SAXBuilder saxBuilder = new SAXBuilder(true);
            saxBuilder.setFeature(SCHEMA_CHECK_FEATURE, true);
            saxBuilder.setFeature(SCHEMA_FULL_CHECK_FEATURE, true);
            saxBuilder.setProperty(SCHEMA_LOCATION_PROPERTY, (Object)("http://www.thinkbuzan.org/IconSchema " + IconResourcesManager.getIconXMLSchemaURLPath()));
            ValidateErrorHandler handler = new ValidateErrorHandler();
            saxBuilder.setErrorHandler((ErrorHandler)handler);
            doc = saxBuilder.build(iconXMLFile);
        }
        catch (JDOMException jde) {
            LOG.error((Object)"Parse tag XML error.", (Throwable)jde);
        }
        catch (IOException ioe) {
            LOG.error((Object)" Read tag XML error.", (Throwable)ioe);
        }
        return doc;
    }

    private void validateGetDocument(File tagXMLFileIn) {
        if (tagXMLFileIn == null) {
            throw new IllegalArgumentException("Tag file can't be null!");
        }
        if (!tagXMLFileIn.exists()) {
            throw new IllegalArgumentException("Tag file doesn't exist!");
        }
    }

    private void initValidateStatus() {
        this.validateStatus = 0;
        this.validateException = null;
    }

    public final int getValidateStatus() {
        return this.validateStatus;
    }

    public final SAXParseException getValidateException() {
        return this.validateException;
    }

    private class ValidateErrorHandler
    extends DefaultHandler {
        private ValidateErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            IconXMLLoader.this.validateStatus = 2;
            IconXMLLoader.this.validateException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            IconXMLLoader.this.validateStatus = 3;
            IconXMLLoader.this.validateException = exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            IconXMLLoader.this.validateStatus = 1;
            IconXMLLoader.this.validateException = exception;
        }
    }
}

