/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.eula.impl;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.gaia.eula.EULA;
import com.thinkbuzan.gaia.eula.exception.EULAException;
import com.thinkbuzan.gaia.eula.ui.v2.EULAOption;
import com.thinkbuzan.gaia.eula.ui.v2.EULAOptionListener;
import com.thinkbuzan.gaia.eula.ui.v2.factory.UIFactory;
import com.thinkbuzan.gaia.eula.ui.v2.windows.EULAComponent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public final class EULAImpl
implements EULA {
    private static final Logger LOGGER = Logger.getLogger(EULA.class);
    private static final String VERSION = "5.0.0";
    private static final String PREFERENCES_VERSION_KEY = "version";
    private static final String ENABLE_EULA_KEY = "com.thinkbuzan.gaia.enableeula";
    private static final String VERSION_NOT_FOUND = "VERSION_NOT_FOUND";
    private static final int HEX_FF = 255;
    private final transient Preferences hiddenUserPreferences;
    private final transient String locale;
    private final transient BundleContext bundleContext;
    private transient JFrame parentFrame;
    private final transient Preferences systemPrefs;

    public EULAImpl(BundleContext context, PreferencesService preferencesService, JFrame jFrame) {
        this.validateNullArgument(preferencesService, "preferencesService can't be null");
        this.validateNullArgument(context, "context can't be null");
        this.bundleContext = context;
        this.parentFrame = jFrame;
        this.hiddenUserPreferences = this.getHiddenUserPreferences(preferencesService);
        this.locale = this.getLocale(preferencesService);
        this.systemPrefs = preferencesService.getSystemPreferences();
    }

    public boolean validateVersion() {
        if (this.systemPrefs.getBoolean(ENABLE_EULA_KEY, Boolean.TRUE.booleanValue())) {
            String agreedVersion = this.getUserAgreedVersion();
            final String currentVersion = this.getCurrentVersion();
            if (agreedVersion.equals(VERSION_NOT_FOUND) || !agreedVersion.equals(currentVersion)) {
                EULAComponent agreementDialogComponent = UIFactory.getEULADialog(new EULAOptionListener(){

                    public void optionSelected(EULAOption option, final EULAComponent eulaComponent) {
                        switch (option) {
                            case AGREE: {
                                EULAImpl.this.updateUserAgreedVersion(currentVersion);
                                break;
                            }
                            case DECLINE: {
                                EULAImpl.this.updateUserAgreedVersion("0");
                                try {
                                    Bundle systemBundle = EULAImpl.this.bundleContext.getBundle(0L);
                                    if (systemBundle == null) {
                                        throw new EULAException("could not stop the application startup");
                                    }
                                    systemBundle.stop();
                                    break;
                                }
                                catch (BundleException exception) {
                                    LOGGER.error((Object)"could not stop the application startup", (Throwable)exception);
                                    throw new EULAException(exception);
                                }
                            }
                            case SAVE: {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        eulaComponent.save();
                                    }
                                });
                                break;
                            }
                            default: {
                                EULAImpl.this.updateUserAgreedVersion("0");
                                try {
                                    Bundle systemBundle = EULAImpl.this.bundleContext.getBundle(0L);
                                    if (systemBundle == null) {
                                        throw new EULAException("could not stop the application startup");
                                    }
                                    systemBundle.stop();
                                    break;
                                }
                                catch (BundleException exception) {
                                    LOGGER.error((Object)"could not stop the application startup", (Throwable)exception);
                                    throw new EULAException(exception);
                                }
                            }
                        }
                    }
                }, this.parentFrame, this);
                agreementDialogComponent.getComponent().setVisible(true);
                System.setProperty("start.delayed", "true");
            } else if (this.parentFrame != null) {
                this.parentFrame.setVisible(false);
                this.parentFrame.dispose();
                this.parentFrame = null;
            }
        }
        return true;
    }

    public String getLocale() {
        return this.locale;
    }

    private Preferences getHiddenUserPreferences(PreferencesService preferencesService) {
        String userName = System.getProperty("user.name");
        userName = preferencesService.getSystemPreferences().get("user.name", userName);
        return preferencesService.getHiddenUserPreferences(userName);
    }

    private String getLocale(PreferencesService preferencesService) {
        return preferencesService.getSystemPreferences().get("user.locale", Locale.getDefault().toString());
    }

    private String getUserAgreedVersion() {
        return this.hiddenUserPreferences.get(PREFERENCES_VERSION_KEY, VERSION_NOT_FOUND);
    }

    private void updateUserAgreedVersion(String version) {
        this.hiddenUserPreferences.put(PREFERENCES_VERSION_KEY, version);
    }

    private String getCurrentVersion() {
        return this.hashMessage(VERSION);
    }

    private String hashMessage(String message) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Unsupported algorithm SHA-1", e);
        }
        sha1.update(message.getBytes());
        return this.toHexString(sha1.digest());
    }

    private String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    private void validateNullArgument(Object arg, String message) {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

