/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.eula.osgi;

import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.preload.IPreloadContext;
import com.thinkbuzan.chaos.preload.IStartRequestListener;
import com.thinkbuzan.chaos.preload.Preload;
import com.thinkbuzan.gaia.eula.EULA;
import com.thinkbuzan.gaia.eula.impl.EULAImpl;
import com.thinkbuzan.gaia.eula.ui.resources.ResourceManager;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class OSGiManager
implements BundleActivator {
    private static final Logger LOGGER = Logger.getLogger(OSGiManager.class);
    private static final String LOGO_PATH = "orb_16.png";

    public void start(final BundleContext context) {
        OSGiService preloadService = new OSGiService(context, Preload.class);
        preloadService.addListener((IServiceListener)new ServiceAdapter<Preload>(){

            public void serviceAdded(Preload service) {
                service.addStartRequestListener(new IStartRequestListener(){

                    public void startRequested(IPreloadContext preloadContext) {
                        OSGiManager.this.validateVersion(context, preloadContext);
                    }
                });
            }
        });
    }

    private void validateVersion(BundleContext context, IPreloadContext preloadContext) {
        OSGiService preferencesServiceService = new OSGiService(context, PreferencesService.class);
        EULAImpl eula = new EULAImpl(context, (PreferencesService)preferencesServiceService.get(), this.getParentFrame());
        context.registerService(EULA.class.getName(), (Object)eula, null);
        boolean validated = eula.validateVersion();
        preferencesServiceService.close();
        if (!validated) {
            preloadContext.stop();
        }
    }

    private JFrame getParentFrame() {
        JFrame parent = new JFrame();
        try {
            ImageIcon icon = ResourceManager.createImageIcon(LOGO_PATH);
            parent.setIconImage(icon.getImage());
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"could not set the dialog icon", (Throwable)ex);
        }
        return parent;
    }

    public void stop(BundleContext context) {
    }
}

