/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.eula.ui;

import com.thinkbuzan.gaia.eula.impl.EULAImpl;
import com.thinkbuzan.gaia.eula.messages.Messages;
import com.thinkbuzan.gaia.eula.ui.AbstractEULAConfirmDialog;
import com.thinkbuzan.gaia.eula.ui.Option;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.apache.log4j.Logger;

public abstract class AbstractEULADialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1025704624109363516L;
    private static final Logger LOG = Logger.getLogger(AbstractEULADialog.class);
    private static final String LICENSE_AGREEMENT_PAGE_NAME = "/eula_%s.html";
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 500);
    private static final int BUFFER_SIZE = 1024;
    private static final int SIZE_NUMERATOR = 3;
    private static final int SIZE_DENUMERATOR = 4;
    private transient JEditorPane licenseBrowser;
    private transient JButton saveButton;
    private transient JButton copyButton;
    private transient JButton agreeButton;
    private transient JButton declineButton;
    private final transient EULAImpl eula;
    private transient Option option;

    public AbstractEULADialog(JFrame parentFrame, EULAImpl eulaIn) {
        super((Frame)parentFrame, true);
        this.setAlwaysOnTop(true);
        this.validateNullArgument(eulaIn, "eulaIn can't be null");
        this.eula = eulaIn;
        this.setTitle(Messages.getLocalizedText("com.thinkbuzan.i18n.eula.title"));
        this.setDefaultCloseOperation(0);
        this.setSize(this.getDefaultSize());
        this.loadLicensePage();
        this.option = Option.NONE;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                AbstractEULADialog.this.getDeclineButton().requestFocus();
            }

            public void windowClosing(WindowEvent e) {
                AbstractEULADialog.this.decline();
            }
        });
    }

    public final void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("save")) {
            this.save();
        } else if (e.getActionCommand().equals("copy")) {
            this.copy();
        } else if (e.getActionCommand().equals("agree")) {
            this.agree();
        } else if (e.getActionCommand().equals("decline")) {
            this.decline();
        }
    }

    public final Option getOption() {
        return this.option;
    }

    protected final JEditorPane getLicenseBrowser() {
        if (this.licenseBrowser == null) {
            this.licenseBrowser = new JEditorPane();
            this.licenseBrowser.setContentType("text/html");
            this.licenseBrowser.setEditable(false);
            this.licenseBrowser.setName("license");
        }
        return this.licenseBrowser;
    }

    protected final JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getLocalizedText("com.thinkbuzan.i18n.common.save") + "...");
            this.saveButton.setActionCommand("save");
            this.saveButton.addActionListener(this);
            this.saveButton.setName("save");
        }
        return this.saveButton;
    }

    protected final JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton(Messages.getLocalizedText("com.thinkbuzan.i18n.common.copy"));
            this.copyButton.setActionCommand("copy");
            this.copyButton.addActionListener(this);
            this.copyButton.setName("copy");
        }
        return this.copyButton;
    }

    protected final JButton getAgreeButton() {
        if (this.agreeButton == null) {
            this.agreeButton = new JButton(Messages.getLocalizedText("com.thinkbuzan.i18n.eula.agree"));
            this.agreeButton.setActionCommand("agree");
            this.agreeButton.addActionListener(this);
            this.agreeButton.setName("agree");
        }
        return this.agreeButton;
    }

    protected final JButton getDeclineButton() {
        if (this.declineButton == null) {
            this.declineButton = new JButton(Messages.getLocalizedText("com.thinkbuzan.i18n.eula.decline"));
            this.declineButton.setActionCommand("decline");
            this.declineButton.addActionListener(this);
            this.declineButton.setName("decline");
        }
        return this.declineButton;
    }

    protected abstract AbstractEULAConfirmDialog getConfirmDialog();

    private Dimension getDefaultSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        screenSize.width = screenSize.width - screenInsets.left - screenInsets.right;
        screenSize.height = screenSize.height - screenInsets.top - screenInsets.bottom;
        screenSize.width = screenSize.width * 3 / 4;
        screenSize.height = screenSize.height * 3 / 4;
        Dimension size = new Dimension(DEFAULT_SIZE);
        size.width = Math.min(size.width, screenSize.width);
        size.height = Math.min(size.height, screenSize.height);
        return size;
    }

    private void save() {
        final FileChooser fileChooser = new FileChooser();
        String description = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.htmlfiles");
        String extensions = "*.html";
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(description, new String[]{"*.html"}));
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                File file = fileChooser.showSaveDialog(null);
                if (!file.getName().toLowerCase().endsWith(".html")) {
                    file = new File(file.getAbsolutePath() + ".html");
                }
                ByteArrayInputStream is = null;
                FileOutputStream os = null;
                String saveText = null;
                try {
                    saveText = AbstractEULADialog.this.getLicensePlainText();
                    is = new ByteArrayInputStream(saveText.getBytes());
                    os = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    int size = is.read(buffer);
                    if (size > 0) {
                        do {
                            ((OutputStream)os).write(buffer, 0, size);
                        } while ((size = is.read(buffer)) > 0);
                    }
                    os.flush();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    AbstractEULADialog.this.closeStream(is);
                    AbstractEULADialog.this.closeStream(os);
                }
                catch (BadLocationException e2) {
                    LOG.error((Object)e2.getMessage(), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            AbstractEULADialog.this.closeStream(is);
                            AbstractEULADialog.this.closeStream(os);
                            throw throwable;
                        }
                    }
                    AbstractEULADialog.this.closeStream(is);
                    AbstractEULADialog.this.closeStream(os);
                }
                AbstractEULADialog.this.closeStream(is);
                AbstractEULADialog.this.closeStream(os);
            }
        });
    }

    private void copy() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection text = new StringSelection(this.getLicensePlainText());
            clipboard.setContents(text, null);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void agree() {
        this.option = Option.AGREE;
        this.dispose();
    }

    private void decline() {
        AbstractEULAConfirmDialog dialog = this.getConfirmDialog();
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getOption().equals((Object)Option.OK)) {
            this.option = Option.DECLINE;
            this.dispose();
        }
    }

    private void loadLicensePage() {
        try {
            URL page = this.getLicensePage();
            EditorKit editorKit = this.getLicenseBrowser().getEditorKit();
            Document doc = editorKit.createDefaultDocument();
            URLConnection conn = page.openConnection();
            editorKit.read(new InputStreamReader(conn.getInputStream()), doc, 0);
            this.getLicenseBrowser().setDocument(doc);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private URL getLicensePage() throws IOException {
        String language = this.getLanguage(this.eula.getLocale());
        URL page = null;
        if (language != null && !language.equals("")) {
            page = AbstractEULADialog.class.getResource(this.getLicensePagePath(language));
        }
        if (page == null) {
            page = AbstractEULADialog.class.getResource(this.getLicensePagePath("en"));
        }
        if (page == null) {
            throw new IOException("license agreement file not found " + this.getLicensePagePath("en"));
        }
        return page;
    }

    private String getLicensePagePath(String language) {
        return String.format(LICENSE_AGREEMENT_PAGE_NAME, language);
    }

    private String getLanguage(String locale) {
        return locale.split("_")[0];
    }

    private String getLicensePlainText() throws BadLocationException {
        Document doc = this.licenseBrowser.getDocument();
        return doc.getText(0, doc.getLength());
    }

    private void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validateNullArgument(Object arg, String message) {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

