/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.eula.ui.v2.mac;

import com.thinkbuzan.apollo.ui.core.win.component.DialogButton;
import com.thinkbuzan.apollo.ui.core.win.component.LionScrollBarUI;
import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.gaia.eula.impl.EULAImpl;
import com.thinkbuzan.gaia.eula.messages.Messages;
import com.thinkbuzan.gaia.eula.ui.AbstractEULADialog;
import com.thinkbuzan.gaia.eula.ui.resources.ResourceManager;
import com.thinkbuzan.gaia.eula.ui.v2.EULAOption;
import com.thinkbuzan.gaia.eula.ui.v2.EULAOptionListener;
import com.thinkbuzan.gaia.eula.ui.v2.IEULADialog;
import com.thinkbuzan.gaia.eula.ui.v2.windows.EULAComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.apache.log4j.Logger;

public class EULADialog
extends ModalDialog
implements IEULADialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 600);
    private transient JEditorPane licenseBrowser;
    private static final String DIALOG_TITLE = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.title");
    private static final String SAVE_BUTTON_LABEL = Messages.getLocalizedText("com.thinkbuzan.i18n.common.save");
    private static final String AGREE_BUTTON_LABEL = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.agree");
    private static final String DECLINE_BUTTON_LABEL = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.decline");
    private static final String CANCEL_BUTTON_LABEL = Messages.getLocalizedText("com.thinkbuzan.i18n.common.cancel");
    private static final String WARNING_DIALOG_CONTENT = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.confirm.message");
    private static final String DIALOG_SUB_TITLE = "End User License Agreement for iMindMap";
    private static final int BUFFER_SIZE = 1024;
    private final transient EULAImpl eula;
    private static final Logger LOG = Logger.getLogger(EULADialog.class);
    private static final String LICENSE_AGREEMENT_PAGE_NAME = "/eula_en_mac.html";
    private static final int MAIN_TITLE_FONT_STYLE = 0;
    private static final int MAIN_TITLE_FONT_SIZE = 25;
    private static final String MAIN_TITLE_FONT_NAME = "Helvetica";
    private static final Color MAIN_TITLE_FONT_COLOUR = Color.BLACK;
    private static final int SUB_TITLE_FONT_STYLE = 0;
    private static final int SUB_TITLE_FONT_SIZE = 26;
    private static final String SUB_TITLE_FONT_NAME = "Helvetica Light";
    private static final Color SUB_TITLE_FONT_COLOUR = Color.BLACK;
    private EULAComponent parentComponent;
    private Frame owner;
    private EULAOptionListener listener;

    public EULADialog(EULAComponent component, EULAImpl eulaIn, Frame owner, EULAOptionListener optionListener) {
        super(owner, "", false, true, Dialog.ModalityType.DOCUMENT_MODAL);
        this.parentComponent = component;
        this.eula = eulaIn;
        this.listener = optionListener;
        this.owner = owner;
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setOpaque(false);
        JPanel textPanelWrapper = new JPanel();
        textPanelWrapper.setBackground(Color.WHITE);
        textPanelWrapper.setLayout(new BorderLayout());
        textPanelWrapper.setBorder(BorderFactory.createLineBorder(Color.decode("#e2e2e2")));
        textPanelWrapper.add((Component)this.createTextPanel(), "Center");
        JPanel textPanelWrapperWrapper = new JPanel();
        textPanelWrapperWrapper.setOpaque(false);
        textPanelWrapperWrapper.setLayout(new BorderLayout());
        textPanelWrapperWrapper.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        textPanelWrapperWrapper.add((Component)textPanelWrapper, "Center");
        mainPanel.add((Component)this.createTitlePanel(), "North");
        mainPanel.add((Component)textPanelWrapperWrapper, "Center");
        mainPanel.add((Component)this.createButtonsPanel(), "South");
        this.setContent(mainPanel);
        this._contentSection.setBorder(BorderFactory.createEmptyBorder());
        this._bottomPanel.setBorder(BorderFactory.createEmptyBorder());
        this._bottomPanel.removeAll();
        this.setMinimumSize(DIALOG_DIMENSION);
        this.setMaximumSize(DIALOG_DIMENSION);
        this.setPreferredSize(DIALOG_DIMENSION);
        this.setSize(DIALOG_DIMENSION);
    }

    private final JPanel createTitlePanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 40, 0, 40));
        JLabel mainLabel = new JLabel(DIALOG_TITLE);
        mainLabel.setFont(new Font(MAIN_TITLE_FONT_NAME, 0, 25));
        mainLabel.setForeground(MAIN_TITLE_FONT_COLOUR);
        mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JLabel subLabel = new JLabel(DIALOG_SUB_TITLE);
        subLabel.setFont(new Font(SUB_TITLE_FONT_NAME, 0, 26));
        subLabel.setForeground(SUB_TITLE_FONT_COLOUR);
        panel.add(mainLabel);
        panel.add(subLabel);
        return panel;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            ModalOptionDialog.SelectedModalOptionDialogOption selectedOption = this.showAreYouSure(this.owner);
            if (selectedOption != ModalOptionDialog.SelectedModalOptionDialogOption.DECLINE) {
                return;
            }
            new Thread(){

                public void run() {
                    EULADialog.this.listener.optionSelected(EULAOption.DECLINE, EULADialog.this.parentComponent);
                }
            }.start();
        }
        super.setVisible(visible);
    }

    private final JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.decode("#e1e1e1"));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.decode("#c2c2c2")), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
        JPanel savePanel = new JPanel(new FlowLayout(0));
        savePanel.setOpaque(false);
        DialogButton saveButton = new DialogButton(SAVE_BUTTON_LABEL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        EULADialog.this.listener.optionSelected(EULAOption.SAVE, EULADialog.this.parentComponent);
                    }
                }.start();
            }
        }, DialogButton.DialogButtonColour.brightGrey);
        savePanel.add((Component)saveButton);
        JPanel decisionPanel = new JPanel(new FlowLayout(2));
        decisionPanel.setOpaque(false);
        DialogButton agreeButton = new DialogButton(AGREE_BUTTON_LABEL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EULADialog.super.setVisible(false);
                new Thread(){

                    public void run() {
                        EULADialog.this.listener.optionSelected(EULAOption.AGREE, EULADialog.this.parentComponent);
                    }
                }.start();
            }
        }, DialogButton.DialogButtonColour.brightGrey);
        DialogButton declineButton = new DialogButton(DECLINE_BUTTON_LABEL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EULADialog.this.showAreYouSure(EULADialog.this.owner) == ModalOptionDialog.SelectedModalOptionDialogOption.DECLINE) {
                    EULADialog.super.setVisible(false);
                    new Thread(){

                        public void run() {
                            EULADialog.this.listener.optionSelected(EULAOption.DECLINE, EULADialog.this.parentComponent);
                        }
                    }.start();
                }
            }
        }, DialogButton.DialogButtonColour.brightGrey);
        decisionPanel.add((Component)declineButton);
        decisionPanel.add((Component)agreeButton);
        panel.add((Component)savePanel, "West");
        panel.add((Component)decisionPanel, "East");
        return panel;
    }

    private final ModalOptionDialog.SelectedModalOptionDialogOption showAreYouSure(Frame owner) {
        return ModalOptionDialog.showDeclineCancelDialog((Frame)owner, (String)DIALOG_TITLE, (String)WARNING_DIALOG_CONTENT, (String)DECLINE_BUTTON_LABEL, (String)CANCEL_BUTTON_LABEL);
    }

    private final JScrollPane createTextPanel() {
        JEditorPane editor = this.getLicenseBrowser();
        this.loadLicensePage();
        JScrollPane scrollPane = new JScrollPane(editor);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new LionScrollBarUI(scrollPane.getVerticalScrollBar()));
        editor.setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private final JEditorPane getLicenseBrowser() {
        if (this.licenseBrowser == null) {
            this.licenseBrowser = new JEditorPane();
            this.licenseBrowser.setContentType("text/html");
            this.licenseBrowser.setEditable(false);
            this.licenseBrowser.setName("license");
            this.licenseBrowser.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.licenseBrowser;
    }

    private void loadLicensePage() {
        try {
            URL page = this.getLicensePage();
            EditorKit editorKit = this.getLicenseBrowser().getEditorKit();
            Document doc = editorKit.createDefaultDocument();
            URLConnection conn = page.openConnection();
            editorKit.read(new InputStreamReader(conn.getInputStream()), doc, 0);
            this.getLicenseBrowser().setDocument(doc);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private URL getLicensePage() throws IOException {
        String language = this.getLanguage(this.eula.getLocale());
        URL page = null;
        if (language != null && !language.equals("")) {
            page = AbstractEULADialog.class.getResource(this.getLicensePagePath(language));
        }
        if (page == null) {
            page = AbstractEULADialog.class.getResource(this.getLicensePagePath("en"));
        }
        if (page == null) {
            page = ResourceManager.class.getResource("eula_en_mac.html");
        }
        if (page == null) {
            throw new IOException("license agreement file not found " + this.getLicensePagePath("en"));
        }
        return page;
    }

    private String getLicensePagePath(String language) {
        return LICENSE_AGREEMENT_PAGE_NAME;
    }

    private String getLanguage(String locale) {
        return locale.split("_")[0];
    }

    public void save() {
        final FileChooser fileChooser = new FileChooser();
        String description = Messages.getLocalizedText("com.thinkbuzan.i18n.eula.htmlfiles");
        String extensions = "*.html";
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(description, new String[]{"*.html"}));
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                File file = fileChooser.showSaveDialog(null);
                if (!file.getName().toLowerCase().endsWith(".html")) {
                    file = new File(file.getAbsolutePath() + ".html");
                }
                ByteArrayInputStream is = null;
                FileOutputStream os = null;
                String saveText = null;
                try {
                    saveText = EULADialog.this.getLicensePlainText();
                    is = new ByteArrayInputStream(saveText.getBytes());
                    os = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    int size = is.read(buffer);
                    if (size > 0) {
                        do {
                            ((OutputStream)os).write(buffer, 0, size);
                        } while ((size = is.read(buffer)) > 0);
                    }
                    os.flush();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    EULADialog.this.closeStream(is);
                    EULADialog.this.closeStream(os);
                }
                catch (BadLocationException e2) {
                    LOG.error((Object)e2.getMessage(), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            EULADialog.this.closeStream(is);
                            EULADialog.this.closeStream(os);
                            throw throwable;
                        }
                    }
                    EULADialog.this.closeStream(is);
                    EULADialog.this.closeStream(os);
                }
                EULADialog.this.closeStream(is);
                EULADialog.this.closeStream(os);
            }
        });
    }

    private String getLicensePlainText() throws BadLocationException {
        Document doc = this.licenseBrowser.getDocument();
        return doc.getText(0, doc.getLength());
    }

    private void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Component getComponent() {
        return this;
    }
}

