/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.eula.ui.windows;

import com.thinkbuzan.gaia.eula.impl.EULAImpl;
import com.thinkbuzan.gaia.eula.ui.AbstractEULAConfirmDialog;
import com.thinkbuzan.gaia.eula.ui.AbstractEULADialog;
import com.thinkbuzan.gaia.eula.ui.windows.WindowsEULAConfirmDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public final class WindowsEULADialog
extends AbstractEULADialog {
    private static final long serialVersionUID = 5431751032553426725L;
    private static final transient Logger LOGGER = Logger.getLogger(WindowsEULADialog.class);
    private static final Border CONTENT_PANEL_BORDER = new EmptyBorder(10, 12, 10, 12);
    private static final int VERTICAL_GAP = 14;
    private static final int BUTTON_HORIZONTAL_GAP = 8;
    private transient JPanel contentPanel;
    private transient AbstractEULAConfirmDialog confirmDialog;

    public WindowsEULADialog(JFrame parentFrame, EULAImpl eula) {
        super(parentFrame, eula);
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"could not set system L&F", (Throwable)ex);
        }
        this.initComponents();
        this.layoutComponents();
        this.setContentPane(this.contentPanel);
        this.getRootPane().setDefaultButton(this.getDeclineButton());
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (UnsupportedLookAndFeelException ex) {
            LOGGER.warn((Object)"could not revert L&F", (Throwable)ex);
        }
    }

    protected AbstractEULAConfirmDialog getConfirmDialog() {
        return this.confirmDialog;
    }

    private void initComponents() {
        this.confirmDialog = new WindowsEULAConfirmDialog(this);
        this.contentPanel = new JPanel(new BorderLayout(0, 14));
        this.contentPanel.setBorder(CONTENT_PANEL_BORDER);
        this.contentPanel.setBackground(Color.white);
        JButton maxWidthButton = this.getSaveButton();
        if (this.getAgreeButton().getPreferredSize().width > maxWidthButton.getPreferredSize().width) {
            maxWidthButton = this.getAgreeButton();
        }
        if (this.getDeclineButton().getPreferredSize().width > maxWidthButton.getPreferredSize().width) {
            maxWidthButton = this.getDeclineButton();
        }
        this.getSaveButton().setPreferredSize(maxWidthButton.getPreferredSize());
        this.getAgreeButton().setPreferredSize(maxWidthButton.getPreferredSize());
        this.getDeclineButton().setPreferredSize(maxWidthButton.getPreferredSize());
    }

    private void layoutComponents() {
        this.contentPanel.add((Component)new JScrollPane(this.getLicenseBrowser()), "Center");
        this.contentPanel.add((Component)this.makeButtonsPanel(), "South");
    }

    private JPanel makeButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setOpaque(false);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(this.getSaveButton());
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.getAgreeButton());
        buttonsPanel.add(Box.createHorizontalStrut(8));
        buttonsPanel.add(this.getDeclineButton());
        return buttonsPanel;
    }
}

