/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.gaiaapplicationtext.osgi;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.internationalization.Ii18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.preload.IPreloadContext;
import com.thinkbuzan.chaos.preload.IStartRequestListener;
import com.thinkbuzan.chaos.preload.Preload;
import com.thinkbuzan.gaia.gaiaapplicationtext.impl.TextBundle;
import com.thinkbuzan.gaia.gaiaapplicationtext.ui.factory.UIFactory;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.UIManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ApplicationTextManager
implements BundleActivator {
    private transient OSGiService<I18n> service;
    private static final transient String CANCEL_BUTTON = "OptionPane.cancelButtonText";
    private static final transient String NO_BUTTON = "OptionPane.noButtonText";
    private static final transient String YES_BUTTON = "OptionPane.yesButtonText";
    private static final transient String CANCEL_TEXT = "com.thinkbuzan.i18n.common.cancel";
    private static final transient String NO_TEXT = "com.thinkbuzan.i18n.common.no";
    private static final transient String YES_TEXT = "com.thinkbuzan.i18n.common.yes";
    private static final String KEY_PREF_USER_LOCALE = "user.locale";
    private static final String ENABLE_EULA_KEY = "com.thinkbuzan.gaia.enableeula";
    private static final String CHOOSE_LANGUAGE_KEY = "com.thinkbuzan.gaia.languageset";
    private static final String SPELLCHECK_ENABLED = "com.thinkbuzan.gaia.spellcheckEnabled";
    private static final String SPELLCHECK_LOCALE = "com.thinkbuzan.gaia.spellcheck.locale";
    private static final String KEY_ALL = "com.thinkbuzan.license.language.all";
    private static final String KEY_CN = "com.thinkbuzan.license.language.zh_cn";
    private static final String KEY_TW = "com.thinkbuzan.license.language.zh_tw";
    private static final String KEY_JA = "com.thinkbuzan.license.language.ja";
    private static final String KEY_GB = "com.thinkbuzan.license.language.en_GB";
    private static final String KEY_US = "com.thinkbuzan.license.language.en_US";
    private static final String KEY_DE = "com.thinkbuzan.license.language.de";
    private static final String KEY_NL = "com.thinkbuzan.license.language.nl";
    private static final String KEY_ES = "com.thinkbuzan.license.language.es";
    private static final String KEY_PT = "com.thinkbuzan.license.language.pt";
    private static final String KEY_FR = "com.thinkbuzan.license.language.fr";
    private static final String KEY_DA = "com.thinkbuzan.license.language.da";
    private static final String KEY_IT = "com.thinkbuzan.license.language.it";
    private static final String KEY_PL = "com.thinkbuzan.license.language.pl";
    private static final String KEY_RU = "com.thinkbuzan.license.language.ru";

    public final void start(BundleContext context) {
        OSGiService prefsService = new OSGiService(context, PreferencesService.class);
        Preferences preferences = ((PreferencesService)prefsService.get()).getSystemPreferences();
        String defaultUserName = System.getProperty("user.name");
        String userName = preferences.get("user.name", defaultUserName);
        Preferences userPreferences = ((PreferencesService)prefsService.get()).getUserPreferences(userName);
        OSGiService licenseService = new OSGiService(context, PluginLicenseService.class);
        this.service = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)this.service.get();
        List<String> supportedLocales = this.getSupportedLocales((PluginLicenseService)licenseService.get());
        String localeValue = preferences.get(KEY_PREF_USER_LOCALE, Locale.getDefault().toString());
        String defaultLocale = this.chooseDefaultLocale((PluginLicenseService)licenseService.get(), localeValue);
        if (defaultLocale != null) {
            try {
                ((Ii18n)i18n).setLocale(defaultLocale);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        TextBundle languageBundle = new TextBundle(this.getClass().getClassLoader(), "i18nproperties/ApplicationTextMessages");
        if (preferences.getBoolean(ENABLE_EULA_KEY, Boolean.TRUE.booleanValue()) && preferences.getBoolean(CHOOSE_LANGUAGE_KEY, Boolean.TRUE.booleanValue())) {
            this.maybeShowLanguageChooser(context, (org.osgi.service.prefs.Preferences)preferences, (org.osgi.service.prefs.Preferences)userPreferences, i18n, languageBundle, supportedLocales, defaultLocale);
        } else {
            i18n.register((ITextBundle)languageBundle);
        }
        licenseService.close();
        prefsService.close();
    }

    private String chooseDefaultLocale(PluginLicenseService pluginLicenseService, String currentLocale) {
        String defaultLocale = null;
        try {
            if (pluginLicenseService.isLicenseValid(false)) {
                if (pluginLicenseService.getPluginLicense(KEY_ALL) != null) {
                    defaultLocale = currentLocale;
                }
                if (pluginLicenseService.getPluginLicense(KEY_DE) != null) {
                    defaultLocale = "de";
                }
                if (pluginLicenseService.getPluginLicense(KEY_NL) != null) {
                    defaultLocale = "nl";
                }
                if (pluginLicenseService.getPluginLicense(KEY_ES) != null) {
                    defaultLocale = "es";
                }
                if (pluginLicenseService.getPluginLicense(KEY_PT) != null) {
                    defaultLocale = "pt";
                }
                if (pluginLicenseService.getPluginLicense(KEY_FR) != null) {
                    defaultLocale = "fr";
                }
                if (pluginLicenseService.getPluginLicense(KEY_DA) != null) {
                    defaultLocale = "da";
                }
                if (pluginLicenseService.getPluginLicense(KEY_IT) != null) {
                    defaultLocale = "it";
                }
                if (pluginLicenseService.getPluginLicense(KEY_PL) != null) {
                    defaultLocale = "pl";
                }
                if (pluginLicenseService.getPluginLicense(KEY_RU) != null) {
                    defaultLocale = "ru";
                }
                if (pluginLicenseService.getPluginLicense(KEY_TW) != null) {
                    defaultLocale = "zh_TW";
                }
                if (pluginLicenseService.getPluginLicense(KEY_CN) != null) {
                    defaultLocale = "zh_CN";
                }
                if (pluginLicenseService.getPluginLicense(KEY_JA) != null) {
                    defaultLocale = "ja";
                }
                if (pluginLicenseService.getPluginLicense(KEY_US) != null) {
                    defaultLocale = "en_US";
                }
                if (pluginLicenseService.getPluginLicense(KEY_GB) != null) {
                    defaultLocale = "en_GB";
                }
            }
        }
        catch (Exception ex) {
            return currentLocale;
        }
        return defaultLocale;
    }

    private List<String> getSupportedLocales(PluginLicenseService pluginLicenseService) {
        ArrayList<String> locales = new ArrayList<String>();
        try {
            if (pluginLicenseService.isLicenseValid(false)) {
                if (pluginLicenseService.getPluginLicense(KEY_ALL) != null) {
                    locales.add("en_GB");
                    locales.add("en_US");
                    locales.add("ja");
                    locales.add("de");
                    locales.add("nl");
                    locales.add("es");
                    locales.add("pt");
                    locales.add("fr");
                    locales.add("da");
                    locales.add("zh_TW");
                    locales.add("zh_CN");
                    locales.add("it");
                    locales.add("pl");
                    locales.add("ru");
                } else {
                    if (pluginLicenseService.getPluginLicense(KEY_DE) != null) {
                        locales.add("de");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_NL) != null) {
                        locales.add("nl");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_ES) != null) {
                        locales.add("es");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_PT) != null) {
                        locales.add("pt");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_FR) != null) {
                        locales.add("fr");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_DA) != null) {
                        locales.add("da");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_IT) != null) {
                        locales.add("it");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_PL) != null) {
                        locales.add("pl");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_RU) != null) {
                        locales.add("ru");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_TW) != null) {
                        locales.add("zh_TW");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_CN) != null) {
                        locales.add("zh_CN");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_JA) != null) {
                        locales.add("ja");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_US) != null) {
                        locales.add("en_US");
                    }
                    if (pluginLicenseService.getPluginLicense(KEY_GB) != null) {
                        locales.add("en_GB");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locales;
    }

    private void maybeShowLanguageChooser(BundleContext context, final org.osgi.service.prefs.Preferences preferences, final org.osgi.service.prefs.Preferences userPreferences, final I18n i18n, final ITextBundle languageBundle, final List<String> licensedLocales, final String defaultLocale) {
        OSGiService preloadService = new OSGiService(context, Preload.class);
        preloadService.addListener((IServiceListener)new ServiceAdapter<Preload>(){

            public void serviceAdded(Preload service) {
                service.addStartRequestListener(new IStartRequestListener(){

                    public void startRequested(IPreloadContext preloadContext) {
                        String option = UIFactory.showLanguageChooserDialog(licensedLocales, defaultLocale);
                        preferences.putBoolean(ApplicationTextManager.CHOOSE_LANGUAGE_KEY, Boolean.FALSE.booleanValue());
                        preferences.put(ApplicationTextManager.KEY_PREF_USER_LOCALE, option);
                        try {
                            ((Ii18n)i18n).setLocale(option);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        String selectedLocale = option;
                        List<String> localesWithSpellchecker = Arrays.asList("en_GB", "en_US", "de", "nl", "es", "pt", "fr", "it", "da");
                        if (localesWithSpellchecker.contains(selectedLocale)) {
                            userPreferences.putBoolean(ApplicationTextManager.SPELLCHECK_ENABLED, true);
                            userPreferences.put(ApplicationTextManager.SPELLCHECK_LOCALE, option);
                        } else {
                            userPreferences.putBoolean(ApplicationTextManager.SPELLCHECK_ENABLED, false);
                        }
                        i18n.register(languageBundle);
                        UIManager.put(ApplicationTextManager.CANCEL_BUTTON, i18n.getLocalizedText(ApplicationTextManager.CANCEL_TEXT));
                        UIManager.put(ApplicationTextManager.NO_BUTTON, i18n.getLocalizedText(ApplicationTextManager.NO_TEXT));
                        UIManager.put(ApplicationTextManager.YES_BUTTON, i18n.getLocalizedText(ApplicationTextManager.YES_TEXT));
                    }
                });
            }
        });
        preloadService.close();
    }

    public final void stop(BundleContext context) {
        this.service.close();
    }
}

