/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.gaiaapplicationtext.resources;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public final class Messages {
    public static final String SELECT_LANGUAGE = "com.thinkbuzan.i18n.common.setLanguage";
    public static final String CONTINUE = "com.thinkbuzan.i18n.licensing.continue";
    public static final String SELECT = "com.thinkbuzan.i18n.common.select";
    private static final Logger LOGGER = Logger.getLogger(Messages.class);
    private static final String BUNDLE_NAME = "i18nproperties/Messages";
    private static final String ROLLBACK_BUNDLE_NAME = "i18nproperties/messages";
    private static ResourceBundle resourceBundle;
    private static ResourceBundle defaultResourceBundle;

    private Messages() {
    }

    public static void setLocale(String targetLocale) {
        ResourceBundle targetResourceBundle;
        try {
            targetResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Messages.getLocale(targetLocale));
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(Messages.class).debug((Object)"No resource bundle found for target locale", (Throwable)ex);
            return;
        }
        resourceBundle = targetResourceBundle;
    }

    public static Locale getLocale(String targetLocale) {
        int languageCodeLength = 2;
        int countryCodeLength = 2;
        if (targetLocale.length() <= 2) {
            return new Locale(targetLocale.substring(0, 2));
        }
        if (targetLocale.length() >= 5) {
            return new Locale(targetLocale.substring(0, 2), targetLocale.substring(3, 5));
        }
        return Locale.UK;
    }

    public static String getLocalizedText(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return Messages.getDefaultString(key);
        }
    }

    private static String getDefaultString(String key) {
        try {
            return defaultResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOGGER.warn((Object)("Text for key [" + key + "] not found"));
            return '!' + key + '!';
        }
    }

    public static String getLocalizedText(String key, String ... params) {
        String value = Messages.getLocalizedText(key);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                value = value.replace("{" + i + "}", params[i]);
            }
        }
        return value;
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
            defaultResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.UK);
        }
        catch (Exception exc) {
            LOGGER.error((Object)("Error caught initializing resource bundles" + exc.getMessage() + ", rolling back to " + ROLLBACK_BUNDLE_NAME));
            resourceBundle = ResourceBundle.getBundle(ROLLBACK_BUNDLE_NAME);
            defaultResourceBundle = ResourceBundle.getBundle(ROLLBACK_BUNDLE_NAME, Locale.UK);
        }
    }
}

