/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.gaiaapplicationtext.resources;

import com.thinkbuzan.apollo.ui.core.RetinaIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public final class ResourceManager {
    private static final String DOT = ".";
    private static final String RETINA = "@2x.";

    private ResourceManager() {
    }

    public static ImageIcon createImageIcon(String fileName) {
        InputStream inputStream = ResourceManager.class.getResourceAsStream(fileName);
        try {
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (IOException e) {
            Logger.getLogger(ResourceManager.class).debug((Object)("Could not load icon " + fileName));
            return null;
        }
    }

    public static BufferedImage getBufferedImage(String filename) {
        BufferedImage img = null;
        try {
            InputStream input = ResourceManager.class.getResourceAsStream(filename);
            img = ImageIO.read(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getLogger(ResourceManager.class).debug((Object)("Failed to load resource: " + filename), (Throwable)e);
        }
        return img;
    }

    public static RetinaIcon getRetinaIcon(String filename) {
        BufferedImage img = ResourceManager.getBufferedImage(filename);
        String filename2x = filename.replace(DOT, RETINA);
        BufferedImage img2x = ResourceManager.getBufferedImage(filename2x);
        return new RetinaIcon((Image)img, (Image)img2x);
    }
}

