/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.gaiaapplicationtext.ui;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.gaiaapplicationtext.resources.ResourceManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class AbstractLanguageChooserPanel
extends JPanel {
    private static final long serialVersionUID = -7802991050562996309L;
    private static final String MAC = "mac/";
    private static final String WIN = "win/";
    public static final String LOCALE_GB = "en_GB";
    public static final String LOCALE_ENGLISH = "en";
    public static final String LOCALE_US = "en_US";
    public static final String LOCALE_JAPAN = "ja";
    public static final String LOCALE_GERMAN = "de";
    public static final String LOCALE_DUTCH = "nl";
    public static final String LOCALE_SPANISH = "es";
    public static final String LOCALE_PORTUGUESE = "pt";
    public static final String LOCALE_FRENCH = "fr";
    public static final String LOCALE_DANISH = "da";
    public static final String LOCALE_CHINESE_TRAD = "zh_TW";
    public static final String LOCALE_CHINESE = "zh_CN";
    public static final String LOCALE_ITALIAN = "it";
    public static final String LOCALE_POLISH = "pl";
    public static final String LOCALE_RUSSIAN = "ru";

    public abstract String getSelection();

    protected final void populateAppLocales(Map<String, String> locales, String currentLocale, List<String> supportedLocales) {
        String userLocale = currentLocale;
        if (LOCALE_ENGLISH.equals(userLocale)) {
            userLocale = LOCALE_GB;
        }
        if (supportedLocales.contains(LOCALE_GB)) {
            locales.put("English GB", LOCALE_GB);
        }
        if (supportedLocales.contains(LOCALE_US)) {
            locales.put("English US", LOCALE_US);
        }
        if (supportedLocales.contains(LOCALE_JAPAN)) {
            locales.put("\u65e5\u672c\u8a9e", LOCALE_JAPAN);
        }
        if (supportedLocales.contains(LOCALE_GERMAN)) {
            locales.put("Deutsch", LOCALE_GERMAN);
        }
        if (supportedLocales.contains(LOCALE_DUTCH)) {
            locales.put("Nederlands", LOCALE_DUTCH);
        }
        if (supportedLocales.contains(LOCALE_SPANISH)) {
            locales.put("Espa\u00f1ol", LOCALE_SPANISH);
        }
        if (supportedLocales.contains(LOCALE_PORTUGUESE)) {
            locales.put("Portugu\u00eas", LOCALE_PORTUGUESE);
        }
        if (supportedLocales.contains(LOCALE_FRENCH)) {
            locales.put("Fran\u00e7ais", LOCALE_FRENCH);
        }
        if (supportedLocales.contains(LOCALE_DANISH)) {
            locales.put("Dansk", LOCALE_DANISH);
        }
        if (supportedLocales.contains(LOCALE_CHINESE_TRAD)) {
            locales.put("\u4e2d\u6587\uff08\u7e41\u9ad4\uff09", LOCALE_CHINESE_TRAD);
        }
        if (supportedLocales.contains(LOCALE_CHINESE)) {
            locales.put("\u7b80\u4f53\u4e2d\u6587\uff08\u4e2d\u56fd\uff09", LOCALE_CHINESE);
        }
        if (supportedLocales.contains(LOCALE_ITALIAN)) {
            locales.put("Italiano", LOCALE_ITALIAN);
        }
        if (supportedLocales.contains(LOCALE_POLISH)) {
            locales.put("Polski", LOCALE_POLISH);
        }
        if (supportedLocales.contains(LOCALE_RUSSIAN)) {
            locales.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", LOCALE_RUSSIAN);
        }
    }

    protected final boolean isActive(String locale) {
        String country = Locale.getDefault().getCountry();
        String lang = Locale.getDefault().getLanguage();
        String full = LOCALE_ENGLISH.equals(Locale.getDefault().toString()) ? LOCALE_GB : Locale.getDefault().toString();
        boolean active = false;
        if (full.equalsIgnoreCase(locale)) {
            active = true;
        } else if (lang.equalsIgnoreCase(locale)) {
            active = true;
        } else if (country.equalsIgnoreCase(locale)) {
            active = true;
        }
        return active;
    }

    protected final Icon getIconForLocale(String locale) {
        Object icon = SystemInfo.isAnyMac() ? (LOCALE_US.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_EnglishUS_active.png") : (LOCALE_JAPAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Japan_active.png") : (LOCALE_GERMAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Germany_active.png") : (LOCALE_DUTCH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Netherlands_active.png") : (LOCALE_SPANISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Spain_active.png") : (LOCALE_PORTUGUESE.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Portugal_active.png") : (LOCALE_FRENCH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_France_active.png") : (LOCALE_DANISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Denmark_active.png") : (LOCALE_CHINESE_TRAD.equalsIgnoreCase(locale) || LOCALE_CHINESE.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_China_active.png") : (LOCALE_ITALIAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Italy_active.png") : (LOCALE_POLISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Poland_active.png") : (LOCALE_RUSSIAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Russia_active.png") : ResourceManager.getRetinaIcon("mac/Flag_English_active.png"))))))))))))) : (LOCALE_US.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-usa.png") : (LOCALE_JAPAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-japan.png") : (LOCALE_GERMAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-germany.png") : (LOCALE_DUTCH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-netherlands.png") : (LOCALE_SPANISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-spain.png") : (LOCALE_PORTUGUESE.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-portugal.png") : (LOCALE_FRENCH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-france.png") : (LOCALE_DANISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-denmark.png") : (LOCALE_CHINESE_TRAD.equalsIgnoreCase(locale) || LOCALE_CHINESE.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-china.png") : (LOCALE_ITALIAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-italy.png") : (LOCALE_POLISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-poland.png") : (LOCALE_RUSSIAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-russia.png") : ResourceManager.createImageIcon("win/language-icon-uk.png")))))))))))));
        return icon;
    }

    protected final Icon getInactiveIconForLocale(String locale) {
        Object icon = SystemInfo.isAnyMac() ? (LOCALE_US.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_EnglishUS.png") : (LOCALE_JAPAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Japan.png") : (LOCALE_GERMAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Germany.png") : (LOCALE_DUTCH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Netherlands.png") : (LOCALE_SPANISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Spain.png") : (LOCALE_PORTUGUESE.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Portugal.png") : (LOCALE_FRENCH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_France.png") : (LOCALE_DANISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Denmark.png") : (LOCALE_CHINESE_TRAD.equalsIgnoreCase(locale) || LOCALE_CHINESE.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_China.png") : (LOCALE_ITALIAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Italy.png") : (LOCALE_POLISH.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Poland.png") : (LOCALE_RUSSIAN.equalsIgnoreCase(locale) ? ResourceManager.getRetinaIcon("mac/Flag_Russia.png") : ResourceManager.getRetinaIcon("mac/Flag_English.png"))))))))))))) : (LOCALE_US.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-usa-inactive.png") : (LOCALE_JAPAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-japan-inactive.png") : (LOCALE_GERMAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-germany-inactive.png") : (LOCALE_DUTCH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-netherlands-inactive.png") : (LOCALE_SPANISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-spain-inactive.png") : (LOCALE_PORTUGUESE.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-portugal-inactive.png") : (LOCALE_FRENCH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-france-inactive.png") : (LOCALE_DANISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-denmark-inactive.png") : (LOCALE_CHINESE_TRAD.equalsIgnoreCase(locale) || LOCALE_CHINESE.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-china-inactive.png") : (LOCALE_ITALIAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-italy-inactive.png") : (LOCALE_POLISH.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-poland-inactive.png") : (LOCALE_RUSSIAN.equalsIgnoreCase(locale) ? ResourceManager.createImageIcon("win/language-icon-russia-inactive.png") : ResourceManager.createImageIcon("win/language-icon-uk-inactive.png")))))))))))));
        return icon;
    }
}

