/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.gaiaapplicationtext.ui.windows;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.gaiaapplicationtext.ui.AbstractLanguageChooserPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WindowsLanguageChooserPanel
extends AbstractLanguageChooserPanel {
    private static final long serialVersionUID = -1936683299615593903L;
    private static final int FONT_SIZE = 12;
    private static final int H_PADDING = 10;
    private static final int V_PADDING = 5;
    private static final int COLUMNS = 3;
    private static final String SAFE_FONT = "Serif";
    private transient String selection = "en_GB";

    public WindowsLanguageChooserPanel(List<String> supportedLocales, String currentLocale) {
        TreeMap<String, String> localeList = new TreeMap<String, String>();
        this.populateAppLocales(localeList, currentLocale, supportedLocales);
        this.selection = currentLocale;
        final ArrayList<JLabel> localeFlags = new ArrayList<JLabel>();
        MouseAdapter mouseAd = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getSource() instanceof JLabel) {
                    WindowsLanguageChooserPanel.this.checkLabelsForSelection(localeFlags, event);
                }
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        Font font = ApplicationFont.getRegularFont((int)0, (float)12.0f);
        for (String locale : localeList.keySet()) {
            JLabel flag = new JLabel(locale, this.getInactiveIconForLocale((String)localeList.get(locale)), 2);
            if (font.canDisplayUpTo(locale) < 0) {
                flag.setFont(font);
            } else {
                flag.setFont(new Font(SAFE_FONT, font.getStyle(), font.getSize()));
            }
            flag.setName((String)localeList.get(locale));
            flag.setCursor(Cursor.getPredefinedCursor(12));
            flag.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            flag.addMouseListener(mouseAd);
            localeFlags.add(flag);
            panel.add((Component)flag, constraints);
            ++constraints.gridx;
            if (constraints.gridx == 3) {
                constraints.gridx = 0;
                ++constraints.gridy;
            }
            if (!this.isActive((String)localeList.get(locale))) continue;
            flag.setIcon(this.getIconForLocale((String)localeList.get(locale)));
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)panel, "Center");
    }

    private void checkLabelsForSelection(List<JLabel> localeFlags, MouseEvent event) {
        for (JLabel locale : localeFlags) {
            if (locale.getName().equalsIgnoreCase(((JLabel)event.getSource()).getName())) {
                locale.setIcon(this.getIconForLocale(locale.getName()));
                this.selection = locale.getName();
                continue;
            }
            locale.setIcon(this.getInactiveIconForLocale(locale.getName()));
        }
    }

    @Override
    public final String getSelection() {
        return this.selection;
    }
}

