/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.appmeta.impl;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.ctc.wstx.stax.WstxInputFactory;
import com.thinkbuzan.gaia.appmeta.AppMetadataManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom2.Document;
import org.jdom2.input.StAXStreamBuilder;
import org.jdom2.output.DOMOutputter;

public class AppMetadataManagerImpl
implements AppMetadataManager {
    private static final transient Logger LOG = Logger.getLogger(AppMetadataManagerImpl.class);
    public static final String ROOT_TAG = "AppMetadata";
    private static final String APP_METADATA_FILE_NAME = "appmeta" + File.separator + "appmeta.xml";
    private final transient File appMetadataFile;
    private transient org.jdom.Document appMetadata;

    public AppMetadataManagerImpl(FileAccessService fileAccessServiceIn) {
        this.validateAppMetadataManagerImpl(fileAccessServiceIn);
        this.appMetadataFile = fileAccessServiceIn.getUserFile(APP_METADATA_FILE_NAME);
        this.loadAppMetaDataFile();
    }

    private void validateAppMetadataManagerImpl(FileAccessService fileAccessServiceIn) {
        if (fileAccessServiceIn == null) {
            throw new IllegalArgumentException("File access service can't be null!");
        }
    }

    private void loadAppMetaDataFile() {
        boolean exist = this.appMetadataFile.exists();
        if (!exist) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Application meta data file does not exist, Create new one!");
            }
            this.appMetadata = new org.jdom.Document(new Element(ROOT_TAG));
            return;
        }
        StAXStreamBuilder builder = new StAXStreamBuilder();
        try {
            WstxInputFactory inputFactory = new WstxInputFactory();
            XMLStreamReader reader = inputFactory.createXMLStreamReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.appMetadataFile.getAbsolutePath()), "UTF-8")));
            Document doc = builder.build(reader);
            if (doc != null) {
                org.w3c.dom.Document domDocument = new DOMOutputter().output(doc);
                this.appMetadata = new DOMBuilder().build(domDocument);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Parse application meta data file failed!", (Throwable)e);
        }
        if (this.appMetadata == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Application meta data file destroyed,create a new document to store app meta data.");
            }
            this.appMetadata = new org.jdom.Document(new Element(ROOT_TAG));
        }
    }

    public final Element getElement(String elementName) {
        this.validateGetElement(elementName);
        Element root = this.appMetadata.getRootElement();
        String rootName = root.getName();
        if (rootName.equalsIgnoreCase(elementName)) {
            return root;
        }
        Iterator it = root.getDescendants();
        while (it.hasNext()) {
            Element element;
            String name;
            Object obj = it.next();
            if (!(obj instanceof Element) || !(name = (element = (Element)obj).getName()).equalsIgnoreCase(elementName)) continue;
            return element;
        }
        return null;
    }

    private void validateGetElement(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name can't be null!");
        }
        if (elementName.trim().equals("")) {
            throw new IllegalArgumentException("Element name can't be empty!");
        }
    }

    public final void putElement(Element value) {
        this.validatePutElement(value);
        Element root = this.appMetadata.getRootElement();
        root.addContent((Content)value);
    }

    private void validatePutElement(Element value) {
        if (value == null) {
            throw new IllegalArgumentException("Element  can't be null!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        XMLOutputter outputter = new XMLOutputter();
        FileOutputStream out = null;
        try {
            if (!this.appMetadataFile.exists()) {
                File folder = this.appMetadataFile.getParentFile();
                folder.mkdirs();
            }
            out = new FileOutputStream(this.appMetadataFile);
            outputter.output(this.appMetadata, (OutputStream)out);
        }
        catch (Exception e) {
            LOG.error((Object)"Save application metadata  failed!", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"close application metadata file stream failed!", (Throwable)e);
                }
            }
        }
    }
}

