/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image;

import com.buzanonline.chaos.preferences.PreferencesService;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.BasicExportPanel;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.removeme.RemoveMe;
import com.thinkbuzan.gaia.export.image.ui.AbstractSizeChooserPanel;
import com.thinkbuzan.gaia.export.image.ui.MacSizeChooserPanel;
import com.thinkbuzan.gaia.export.image.ui.WindowsSizeChooserPanel;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.gaia.export.image.writers.PNGWriter;
import com.thinkbuzan.pascal.services.editor.IPainter;
import com.thinkbuzan.phoenix.licensing.LicenseService;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractImageExporter
implements IExporter {
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String PDF = "pdf";
    private final transient String name;
    private transient Icon icon;
    private transient AbstractSizeChooserPanel options = null;
    private final transient EditorManager editorManagerRef;
    private final transient PluginLicenseService licenseService;
    private final transient PreferencesService preferenceService;
    protected static final String[] JPEG_FILE_EXT = new String[]{"jpg", "jpeg"};
    protected static final String[] PNG_FILE_EXT = new String[]{"png"};
    protected static final String[] PDF_FILE_EXT = new String[]{"pdf"};
    protected static final String JPEG_DESC = "JPEG File (*.jpeg, *.jpg)";
    protected static final String PNG_DESC = "PNG File (*.png)";
    protected static final String PDF_DESC = "PDF File (*.pdf)";
    private static final String NAME_KEY = "com.thinkbuzan.i18n.common.windows.rt.imagefile.title";

    public AbstractImageExporter(EditorManager editorManager, PluginLicenseService licenseServiceIn, PreferencesService preferenceServiceIn) {
        this.editorManagerRef = editorManager;
        this.licenseService = licenseServiceIn;
        this.preferenceService = preferenceServiceIn;
        this.name = ImageExporterI18n.getLocalizedText(NAME_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon lazyGetIcon() {
        AbstractImageExporter abstractImageExporter = this;
        synchronized (abstractImageExporter) {
            if (this.icon == null) {
                this.icon = RemoveMe.getIcon("IMAGE");
            }
            return this.icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final AbstractSizeChooserPanel lazyGetOptions() {
        AbstractImageExporter abstractImageExporter = this;
        synchronized (abstractImageExporter) {
            if (!Category.CategoryId.PDF_IMAGE.equals((Object)this.getCategoryId()) && this.options == null) {
                if (SystemInfo.isWindows() || SystemInfo.isLinux()) {
                    this.options = new WindowsSizeChooserPanel();
                } else if (SystemInfo.isAnyMac()) {
                    this.options = new MacSizeChooserPanel();
                } else {
                    throw new IllegalArgumentException("illegal os");
                }
            }
            return this.options;
        }
    }

    protected abstract String getFileType(File var1);

    protected abstract ImageWriter getWriter(String var1);

    public final void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener) {
        this.export(editorComponent, null, outputFile, exporterListener);
    }

    private void export(IEditorComponent editorComponent, BufferedImage image, File outputFile, IExporterListener exporterListener) {
        this.validateExport(editorComponent, outputFile, exporterListener);
        float progress = 0.1f;
        if (image == null) {
            Dimension selectedSize;
            File updatedOutputFile;
            if (SystemInfo.isAnyMac() && this.lazyGetOptions() instanceof MacSizeChooserPanel) {
                String fileName = outputFile.getAbsolutePath();
                String filenameNoExtension = fileName.substring(0, fileName.lastIndexOf(46));
                String chosenExtension = ((MacSizeChooserPanel)this.lazyGetOptions()).getChosenExtension();
                fileName = filenameNoExtension + "." + chosenExtension;
                updatedOutputFile = new File(fileName);
            } else {
                updatedOutputFile = outputFile;
            }
            updatedOutputFile = new File(updatedOutputFile.getAbsolutePath());
            String type = this.getFileType(updatedOutputFile);
            ImageWriter writer = this.getWriter(type);
            exporterListener.exportProgress(0.1f);
            IPainter painter = this.createPainter(editorComponent);
            if (this.lazyGetOptions() == null) {
                selectedSize = null;
            } else {
                if (writer instanceof PNGWriter) {
                    painter.setBackgroundPainted(!this.lazyGetOptions().getTransparencySetting());
                }
                selectedSize = this.lazyGetOptions().getSelectedSize();
            }
            writer.write(updatedOutputFile, painter, type, selectedSize);
            exporterListener.exportProgress(1.0f);
        } else {
            String type = this.getFileType(outputFile);
            ImageWriter writer = this.getWriter(type);
            exporterListener.exportProgress(0.1f);
            writer.write(outputFile, image, type);
            exporterListener.exportProgress(1.0f);
        }
    }

    public final void export(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn, Object ... objects) {
        if (objects.length == 1 && objects[0] instanceof BufferedImage) {
            this.export(editorComponent, (BufferedImage)objects[0], outputFileIn, exporterListenerIn);
        } else {
            if (this.lazyGetOptions() != null) {
                this.getComponent();
                int imageWidth = 0;
                int imageHeight = 0;
                boolean keepAspect = false;
                if (objects.length > 0 && objects[0] instanceof Integer) {
                    imageWidth = (Integer)objects[0];
                }
                if (objects.length > 1 && objects[1] instanceof Integer) {
                    imageHeight = (Integer)objects[1];
                    this.lazyGetOptions().setSizeValues(imageWidth, imageHeight, keepAspect);
                }
                if (objects.length > 2 && objects[2] instanceof Boolean) {
                    keepAspect = (Boolean)objects[2];
                    this.lazyGetOptions().setSizeValues(imageWidth, imageHeight, keepAspect);
                }
            }
            this.export(editorComponent, outputFileIn, exporterListenerIn);
        }
    }

    private void validateExport(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn) {
        if (editorComponent == null) {
            throw new IllegalArgumentException("Editor component can't be null!");
        }
        if (outputFileIn == null) {
            throw new IllegalArgumentException("Out put file can't be null!");
        }
        if (exporterListenerIn == null) {
            throw new IllegalArgumentException("Exporter listener can't be null!");
        }
    }

    public final JComponent getComponent() {
        AbstractSizeChooserPanel panel;
        IEditorComponent editorComponent = null;
        try {
            editorComponent = this.editorManagerRef.getCurrentEditorComponent();
        }
        catch (IllegalArgumentException ex) {
            editorComponent = null;
        }
        AbstractSizeChooserPanel optionsPanel = this.lazyGetOptions();
        if (editorComponent != null && optionsPanel != null) {
            IPainter painter = this.createPainter(editorComponent);
            Dimension size = painter.getPaintBounds().getBounds().getSize();
            optionsPanel.setAspectRatio(size.width, size.height);
        }
        if ((panel = optionsPanel) == null) {
            panel = new BasicExportPanel(ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.common.createpdfimage"), false);
        }
        panel.setOpaque(false);
        return panel;
    }

    private IPainter createPainter(IEditorComponent editorComponent) {
        IPainter painter = editorComponent.createPainter(true, false);
        painter.setBackgroundPainted(true);
        return painter;
    }

    public final Icon getIcon() {
        return this.lazyGetIcon();
    }

    public final String getName() {
        return this.name;
    }

    public final IExporter.LicenseState getLicenseState() {
        return IExporter.LicenseState.full;
    }

    protected final LicenseService getLicenseService() {
        return this.licenseService;
    }

    protected final PreferencesService getPreferencesService() {
        return this.preferenceService;
    }
}

