/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.i18n;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.export.image.ui.PresetEnum;

public final class ImageExporterI18n {
    private static I18n i18n;
    private static final String THUMBNAIL = "com.thinkbuzan.i18n.imageexporter.ui.thumbnail";
    private static final String EMAIL = "com.thinkbuzan.i18n.common.email";
    private static final String WEB = "com.thinkbuzan.i18n.common.web";
    private static final String HIGH_DEFINITION = "com.thinkbuzan.i18n.imageexporter.ui.highDefinition";
    private static final String BEST = "com.thinkbuzan.i18n.imageexporter.ui.best";
    private static final String CUSTOM = "com.thinkbuzan.i18n.imageexporter.ui.custom";
    public static final String WIDTH = "com.thinkbuzan.i18n.imageexporter.ui.width";
    public static final String HEIGHT = "com.thinkbuzan.i18n.imageexporter.ui.height";
    public static final String PRESET = "com.thinkbuzan.i18n.imageexporter.ui.preset";
    public static final String PIXELS = "com.thinkbuzan.i18n.imageexporter.ui.pixels";
    public static final String SIZE = "com.thinkbuzan.i18n.common.size";
    public static final String CANCEL = "com.thinkbuzan.i18n.common.cancel";
    public static final String NEXT = "com.thinkbuzan.i18n.common.cancel";
    public static final String MAINTAINS_ASPECT_RATIO = "com.thinkbuzan.i18n.imageexporter.ui.maintainsAspectRatio";
    public static final String IMAGE_TYPE = "com.thinkbuzan.i18n.imageexporter.ui.imageType";

    private ImageExporterI18n() {
    }

    public static I18n getI18n() {
        return i18n;
    }

    public static void setI18n(I18n i18nIn) {
        ImageExporterI18n.validateSetI18n(i18nIn);
        i18n = i18nIn;
    }

    private static void validateSetI18n(I18n i18nIn) {
        if (i18nIn == null) {
            throw new IllegalArgumentException("I18n must not be null!");
        }
    }

    public static String getLocalizedText(String key) {
        ImageExporterI18n.validateGetLocalizedText(key);
        return i18n.getLocalizedText(key);
    }

    private static void validateGetLocalizedText(String key) {
        if (key == null || "".equals(key.trim())) {
            throw new IllegalArgumentException("The i18n key must not be null!");
        }
    }

    public static String getPresetText(PresetEnum presetEnum) {
        if (presetEnum == PresetEnum.Thumbnail) {
            return ImageExporterI18n.getLocalizedText(THUMBNAIL);
        }
        if (presetEnum == PresetEnum.Email) {
            return ImageExporterI18n.getLocalizedText(EMAIL);
        }
        if (presetEnum == PresetEnum.Web) {
            return ImageExporterI18n.getLocalizedText(WEB);
        }
        if (presetEnum == PresetEnum.High_Definition) {
            return ImageExporterI18n.getLocalizedText(HIGH_DEFINITION);
        }
        if (presetEnum == PresetEnum.Best) {
            return ImageExporterI18n.getLocalizedText(BEST);
        }
        if (presetEnum == PresetEnum.Custom) {
            return ImageExporterI18n.getLocalizedText(CUSTOM);
        }
        return null;
    }
}

