/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.impl;

import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.FileType;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.image.AbstractImageExporter;
import com.thinkbuzan.gaia.export.image.ui.MacSizeChooserPanel;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.gaia.export.image.writers.JPEGWriter;
import com.thinkbuzan.gaia.export.image.writers.PDFWriter;
import com.thinkbuzan.gaia.export.image.writers.PNGWriter;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageExporter
extends AbstractImageExporter {
    private final transient Map<String, List<String>> descExtMap = new HashMap<String, List<String>>();
    private final transient String id;
    private final transient IFileType fileType;

    public ImageExporter(EditorManager editorManager, PluginLicenseService licenseServiceIn, PreferencesService preferenceService) {
        super(editorManager, licenseServiceIn, preferenceService);
        this.id = "com.thinkbuzan.gaia.export.image";
        this.descExtMap.put("JPEG File (*.jpeg, *.jpg)", Arrays.asList(JPEG_FILE_EXT));
        this.descExtMap.put("PNG File (*.png)", Arrays.asList(PNG_FILE_EXT));
        this.descExtMap.put("PDF File (*.pdf)", Arrays.asList(PDF_FILE_EXT));
        this.fileType = new FileType(Arrays.asList("JPEG File (*.jpeg, *.jpg)", "PNG File (*.png)", "PDF File (*.pdf)"), this.descExtMap);
    }

    public final String getId() {
        return this.id;
    }

    public final IFileType getOutputFileType() {
        if (this.lazyGetOptions() instanceof MacSizeChooserPanel) {
            String chosenExtension = ((MacSizeChooserPanel)this.lazyGetOptions()).getChosenExtension();
            if ("JPG".equals(chosenExtension)) {
                return new FileType(Arrays.asList("JPEG File (*.jpeg, *.jpg)"), this.descExtMap);
            }
            if ("PDF".equals(chosenExtension)) {
                return new FileType(Arrays.asList("PDF File (*.pdf)"), this.descExtMap);
            }
            return new FileType(Arrays.asList("PNG File (*.png)"), this.descExtMap);
        }
        return this.fileType;
    }

    public final Category.CategoryId getCategoryId() {
        return Category.CategoryId.IMAGE;
    }

    protected final String getFileType(File outputFile) {
        String fileName = outputFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (this.isValidExtension(JPEG_FILE_EXT, extension) || this.isValidExtension(PNG_FILE_EXT, extension) || this.isValidExtension(PDF_FILE_EXT, extension)) {
            return extension;
        }
        return null;
    }

    private boolean isValidExtension(String[] validExt, String extension) {
        for (String ext : validExt) {
            if (!extension.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    protected final ImageWriter getWriter(String filetype) {
        ImageWriter writer = "jpg".equalsIgnoreCase(filetype) || "jpeg".equalsIgnoreCase(filetype) ? new JPEGWriter(this.getLicenseService()) : ("pdf".equalsIgnoreCase(filetype) ? new PDFWriter(this.getPreferencesService()) : new PNGWriter(this.getLicenseService()));
        return writer;
    }
}

