/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.impl;

import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.FileType;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.image.AbstractImageExporter;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.gaia.export.image.writers.PDFWriter;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfImageExporter
extends AbstractImageExporter {
    private final transient Map<String, List<String>> descExtMap = new HashMap<String, List<String>>();
    private final transient String id;
    private final transient IFileType fileType;

    public PdfImageExporter(EditorManager editorManager, PluginLicenseService licenseServiceIn, PreferencesService preferencesService) {
        super(editorManager, licenseServiceIn, preferencesService);
        this.id = "com.thinkbuzan.gaia.export.image.pdf";
        this.descExtMap.put("PDF File (*.pdf)", Arrays.asList(PDF_FILE_EXT));
        this.fileType = new FileType(Arrays.asList("PDF File (*.pdf)"), this.descExtMap);
    }

    public final String getId() {
        return this.id;
    }

    public final IFileType getOutputFileType() {
        return this.fileType;
    }

    public final Category.CategoryId getCategoryId() {
        return Category.CategoryId.PDF_IMAGE;
    }

    protected final String getFileType(File outputFile) {
        String fileName = outputFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (this.isValidExtension(PDF_FILE_EXT, extension)) {
            return extension;
        }
        return null;
    }

    private boolean isValidExtension(String[] validExt, String extension) {
        for (String ext : validExt) {
            if (!extension.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    protected final ImageWriter getWriter(String filetype) {
        return new PDFWriter(this.getPreferencesService());
    }
}

