/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.impl.PdfImageExporter;
import com.thinkbuzan.gaia.export.image.osgi.BundleLicenser;
import com.thinkbuzan.gaia.export.image.osgi.PrintNativeAction;
import com.thinkbuzan.gaia.export.image.share.ImageShareExporter;
import com.thinkbuzan.gaia.export.image.v2.windows.WindowsImageExporter;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import javax.imageio.spi.IIORegistry;
import org.apache.log4j.Logger;
import org.freehep.graphicsio.gif.GIFImageWriterSpi;
import org.freehep.graphicsio.ppm.PPMImageWriterSpi;
import org.freehep.graphicsio.raw.RawImageWriterSpi;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public final void start(BundleContext context) {
        long start = System.currentTimeMillis();
        final OSGiService exportManagerService = new OSGiService(context, ExportManager.class);
        final ExportManager exportManager = (ExportManager)exportManagerService.get();
        OSGiService i18nService = new OSGiService(context, I18n.class);
        ImageExporterI18n.setI18n((I18n)i18nService.get());
        final OSGiService editorManager = new OSGiService(context, EditorManager.class);
        BundleLicenser.initLicenser(context);
        final PluginLicenseService pluginLicenseService = BundleLicenser.getPluginLicenseService();
        OSGiService actionManService = new OSGiService(context, ActionManager.class);
        final ActionManager actionMan = (ActionManager)actionManService.get();
        actionManService.close();
        actionMan.addAction((IAction)new PrintNativeAction((IEditorManager)editorManager.get(), pluginLicenseService));
        OSGiService prefsService = new OSGiService(context, PreferencesService.class);
        final PreferencesService prefService = (PreferencesService)prefsService.get();
        prefsService.close();
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                exportManager.register((IExporter)new WindowsImageExporter((EditorManager)editorManager.get(), pluginLicenseService, prefService));
                exportManager.register((IExporter)new PdfImageExporter((EditorManager)editorManager.get(), pluginLicenseService, prefService));
                exportManager.register((IExporter)new ImageShareExporter(exportManager, actionMan));
                exportManagerService.close();
            }
        });
        IIORegistry registry = IIORegistry.getDefaultInstance();
        registry.registerServiceProvider(new RawImageWriterSpi());
        registry.registerServiceProvider(new GIFImageWriterSpi());
        registry.registerServiceProvider(new PPMImageWriterSpi());
        long end = System.currentTimeMillis();
        Logger.getLogger(Activator.class).debug((Object)String.format("[BUNDLESTARTTIME] duration=%s, start=%s, end=%s", end - start, start, end));
    }

    public void stop(BundleContext context) {
    }
}

