/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.osgi;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.phoenix.licensing.LicenseState;
import com.thinkbuzan.phoenix.licensing.PluginLicense;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import org.osgi.framework.BundleContext;

public final class BundleLicenser {
    private static final String INTEGRATION_EVERNOTE_LICENSE_ID = "com.thinkbuzan.license.integrations.evernote";
    private static transient PluginLicenseService pluginLicenseService;

    private BundleLicenser() {
    }

    public static void initLicenser(BundleContext context) {
        pluginLicenseService = (PluginLicenseService)new OSGiService(context, PluginLicenseService.class).get();
    }

    public static boolean isEvernoteLicensed() {
        return BundleLicenser.isIdLicensed(INTEGRATION_EVERNOTE_LICENSE_ID);
    }

    private static boolean isLicenseActive(PluginLicense pluginLicense) {
        return pluginLicense != null && LicenseState.valid.equals((Object)pluginLicense.getState());
    }

    public static PluginLicenseService getPluginLicenseService() {
        return pluginLicenseService;
    }

    public static boolean isIdLicensed(String licenseId) {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(licenseId));
    }
}

