/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.osgi;

import com.buzanonline.chaos.action.AbstractAction;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.image.writers.PNGWriter;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IPainter;
import com.thinkbuzan.phoenix.licensing.LicenseService;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PrintNativeAction
extends AbstractAction {
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.PrintNativeAction";
    private final transient PluginLicenseService pluginLicenseRef;
    private final transient IEditorManager editorMan;

    public PrintNativeAction(IEditorManager editorManager, PluginLicenseService pluginLicenseService) {
        this.pluginLicenseRef = pluginLicenseService;
        this.editorMan = editorManager;
    }

    public final void runAction(Object ... parameters) {
        if (this.editorMan.getAllEditorViews().isEmpty() || !(this.editorMan.getCurrentEditorComponent() instanceof IEditorComponent)) {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"No valid editor available");
        } else {
            try {
                File file = File.createTempFile("to_print_" + System.currentTimeMillis(), ".png");
                IPainter painter = ((IEditorComponent)this.editorMan.getCurrentEditorComponent()).createPainter(true, false);
                painter.setBackgroundPainted(true);
                Rectangle2D bounds = painter.getPaintBounds();
                Dimension selectedSize = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
                PNGWriter writer = new PNGWriter((LicenseService)this.pluginLicenseRef);
                writer.write(file, painter, "png", selectedSize);
                if (file.exists()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.PRINT)) {
                        desktop.print(file);
                    } else {
                        Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"No print service available");
                    }
                }
                file.delete();
            }
            catch (IOException e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Failed to render and print image", (Throwable)e);
            }
        }
    }

    public String getId() {
        return ACTION_ID;
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

