/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.resource;

import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.phoenix.licensing.LicenseType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ResourceManager {
    private static final transient Map<String, BufferedImage> IMAGE_CACHE = new HashMap<String, BufferedImage>();
    private static final String WATERMARK_BASIC_PREFIX = "wm_basic_";
    private static final String WATERMARK_TRIAL_PREFIX = "wm_trial_";
    private static final String WATERMARK_EXTENSION = ".png";

    private ResourceManager() {
    }

    private static void validateGetImageIcon(String iamgeFileName) {
        if (null == iamgeFileName || iamgeFileName.length() == 0) {
            throw new IllegalArgumentException(" image file name can't be null or empty");
        }
        InputStream inputStream = ResourceManager.class.getResourceAsStream(iamgeFileName);
        if (null == inputStream) {
            throw new IllegalArgumentException(" image file doesn't exsit.");
        }
    }

    public static BufferedImage getWaterMarkImage(LicenseType type) {
        String resourceType = LicenseType.trial.equals((Object)type) ? WATERMARK_TRIAL_PREFIX : WATERMARK_BASIC_PREFIX;
        Locale locale = ImageExporterI18n.getI18n().getUserLocale();
        String resourceLocale = locale != null && ResourceManager.isAvailable(locale) ? ImageExporterI18n.getI18n().getUserLocale().getLanguage() : "en";
        return ResourceManager.getBufferedImage(resourceType + resourceLocale + WATERMARK_EXTENSION);
    }

    private static boolean isAvailable(Locale locale) {
        return locale.equals(Locale.JAPAN) || locale.equals(Locale.ENGLISH);
    }

    public static BufferedImage getBufferedImage(String imageFileName) {
        return ResourceManager.getBufferedImage(imageFileName, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getBufferedImage(String imageFileName, int bufferedImageType) {
        BufferedImage bufferedImage;
        ResourceManager.validateGetImageIcon(imageFileName);
        Map<String, BufferedImage> map = IMAGE_CACHE;
        synchronized (map) {
            bufferedImage = IMAGE_CACHE.get(imageFileName);
        }
        if (bufferedImage == null) {
            try {
                InputStream inputStream = ResourceManager.class.getResourceAsStream(imageFileName);
                bufferedImage = ImageIO.read(inputStream);
                if (bufferedImageType != -1 && bufferedImage.getType() != bufferedImageType) {
                    BufferedImage convertedBufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImageType);
                    Graphics2D graphics = (Graphics2D)convertedBufferedImage.getGraphics();
                    graphics.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics.dispose();
                    bufferedImage = convertedBufferedImage;
                }
                Map<String, BufferedImage> map2 = IMAGE_CACHE;
                synchronized (map2) {
                    IMAGE_CACHE.put(imageFileName, bufferedImage);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not get BufferedImage \"%s\"", imageFileName));
            }
        }
        return bufferedImage;
    }
}

