/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.share;

import com.buzanonline.chaos.action.ActionManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.ExternalOptionsExportPanel;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.osgi.BundleLicenser;
import com.thinkbuzan.gaia.export.image.resource.ResourceManager;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class ImageShareExporter
implements IExporter {
    private static final String EXPORTER_ID = "com.thinkbuzan.phoenix.export.image.share";
    private static final String ACTION_ID = "com.thinkbuzan.phoenix.externalshare.action.ShowImageShareAction";
    private final transient ExportManager manager;
    private final transient ActionManager actionMan;
    private transient ExternalOptionsExportPanel component;

    public ImageShareExporter(ExportManager exportManager, ActionManager actionManIn) {
        if (exportManager == null) {
            throw new IllegalArgumentException(String.format("Invalid params passed to constructor! exportManager=%s", exportManager));
        }
        if (actionManIn == null) {
            throw new IllegalArgumentException(String.format("Invalid params passed to constructor! actionManIn=%s", actionManIn));
        }
        this.manager = exportManager;
        this.actionMan = actionManIn;
    }

    public void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener) {
        this.actionMan.runAction(ACTION_ID, new Object[0]);
    }

    public void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener, Object ... objects) {
        if (objects != null && objects.length == 1 && objects[0] instanceof String) {
            this.actionMan.runAction(ACTION_ID, new Object[]{(String)objects[0]});
        } else {
            this.actionMan.runAction(ACTION_ID, new Object[0]);
        }
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.IMAGE_SHARE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getComponent() {
        ImageShareExporter imageShareExporter = this;
        synchronized (imageShareExporter) {
            if (this.component == null) {
                this.component = new ExternalOptionsExportPanel(this.manager){
                    private static final long serialVersionUID = -3547956810523110472L;
                    private static final String IMAGE_SHARE_ACTION = "com.thinkbuzan.phoenix.externalshare.action.ShowImageShareAction";
                    private static final String FACEBOOK_PARAM = "facebook";
                    private static final String TWITTER_PARAM = "twitter";
                    private static final String EVERNOTE_PARAM = "evernote";

                    public void createContents() {
                        this.addSectionTitle(this.i18n("com.thinkbuzan.i18n.common.share.image"));
                        this.addOption(this.icon("facebook_48.png"), this.i18n("com.thinkbuzan.i18n.common.sharefacebook"), this.i18n("com.thinkbuzan.i18n.common.sharefacebook.description"), "com.thinkbuzan.gaia.actions.ShareToFacebookAction", new Object[0]);
                        this.addOption(this.icon("twitter_48.png"), this.i18n("com.thinkbuzan.i18n.common.sharetwitter"), this.i18n("com.thinkbuzan.i18n.common.sharetwitter.description"), "com.thinkbuzan.gaia.actions.ShareToTwitterAction", new Object[0]);
                        if (BundleLicenser.isEvernoteLicensed()) {
                            this.addOption(this.icon("evernote_48.png"), this.i18n("com.thinkbuzan.i18n.common.shareevernote"), this.i18n("com.thinkbuzan.i18n.common.shareevernote.description"), "com.thinkbuzan.gaia.actions.ShareToEvernoteAction", new Object[0]);
                        }
                    }

                    private String i18n(String key) {
                        return ImageExporterI18n.getLocalizedText(key);
                    }

                    private Icon icon(String name) {
                        return new ImageIcon(ResourceManager.getBufferedImage(name));
                    }
                };
            }
            return this.component;
        }
    }

    public Icon getIcon() {
        return new ImageIcon(ResourceManager.getBufferedImage("share.png"));
    }

    public String getId() {
        return EXPORTER_ID;
    }

    public IExporter.LicenseState getLicenseState() {
        return IExporter.LicenseState.full;
    }

    public String getName() {
        return ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.common.share.image");
    }

    public IFileType getOutputFileType() {
        return null;
    }
}

