/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.ui;

import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.ui.CustomSpinnerNumberModel;
import com.thinkbuzan.gaia.export.image.ui.PresetEnum;
import com.thinkbuzan.pascal.guielements.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public abstract class AbstractSizeChooserPanel
extends JPanel {
    private static final long serialVersionUID = -2351042153516245141L;
    public static final int MAX_IMAGE_SIZE = 5000;
    private static final int BEST_WIDTH = 3500;
    private static final int HD_WIDTH = 1920;
    private static final int WEB_WIDTH = 800;
    private static final int EMAIL_WIDTH = 640;
    private static final int THUMBNAIL_WIDTH = 300;
    private static final int ROW_MARGIN = 10;
    private static final int LABEL_WIDTH = 70;
    private static final int LABEL_HEIGHT = 20;
    private static final int SPINNER_BOX_WIDTH = 60;
    private static final int MIN_BORDER_X = 20;
    private static final int MIN_BORDER_Y = 40;
    private transient JComboBox presetComboBox;
    private final transient JSpinner widthSpinner = new JSpinner();
    private final transient JSpinner heightSpinner = new JSpinner();
    private transient JCheckBox ratioCheckBox;
    private transient double widthToHeightRatio = 0.0;
    private transient double heightToWidthRatio = 0.0;
    private transient boolean transparency = false;

    public AbstractSizeChooserPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setOpaque(false);
        wrapper.setBorder(BorderFactory.createEmptyBorder(40, 20, 40, 20));
        wrapper.add((Component)this.getOptionPanel(), "North");
        JPanel center = new JPanel(new FlowLayout(1));
        center.setOpaque(false);
        Box verticalBox = Box.createVerticalBox();
        center.add(verticalBox);
        verticalBox.add(this.getSizePanel());
        verticalBox.add(Box.createVerticalStrut(10));
        verticalBox.add(this.getTransparencyPanel());
        wrapper.add((Component)center, "Center");
        this.add((Component)UIUtils.createWrapperPanel((JComponent)wrapper, (boolean)false, (boolean)true), "Center");
    }

    abstract JPanel createExtensionsPanel();

    public final void setSizeValues(int width, int height, boolean keepAspectRatio) {
        this.widthSpinner.setValue(width);
        this.heightSpinner.setValue(height);
        this.ratioCheckBox.setSelected(keepAspectRatio);
    }

    private JPanel getOptionPanel() {
        JLabel label = new JLabel(ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.preset"));
        this.presetComboBox = new JComboBox();
        this.presetComboBox.setOpaque(false);
        for (PresetEnum presetEnum : PresetEnum.values()) {
            this.presetComboBox.addItem(presetEnum);
        }
        JPanel presetPanel = new JPanel(new FlowLayout(1));
        presetPanel.setOpaque(false);
        presetPanel.add(label);
        presetPanel.add(this.presetComboBox);
        JPanel optionPanel = new JPanel(new BorderLayout(10, 10));
        optionPanel.setOpaque(false);
        optionPanel.add((Component)presetPanel, "Center");
        JPanel extensionPanel = this.createExtensionsPanel();
        if (extensionPanel != null) {
            optionPanel.add((Component)extensionPanel, "North");
        }
        return optionPanel;
    }

    private JPanel getSizePanel() {
        JPanel innerPanel = new JPanel(new FlowLayout(1));
        innerPanel.setOpaque(false);
        String panelTitle = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.common.size");
        TitledBorder titleBorder = BorderFactory.createTitledBorder(panelTitle);
        Border innerBorder = BorderFactory.createEmptyBorder(10, 15, 10, 15);
        innerPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder, innerBorder));
        Box verticalBox = Box.createVerticalBox();
        innerPanel.add(verticalBox);
        verticalBox.add(this.getDimensionBox(this.widthSpinner, "com.thinkbuzan.i18n.imageexporter.ui.width"));
        verticalBox.add(Box.createVerticalStrut(10));
        verticalBox.add((Component)this.getDimensionBox(this.heightSpinner, "com.thinkbuzan.i18n.imageexporter.ui.height"), Float.valueOf(0.0f));
        verticalBox.add(Box.createVerticalStrut(10), Float.valueOf(1.0f));
        verticalBox.add(this.createRatioBox());
        this.addPresetListener();
        this.addSpinnerListeners();
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.setOpaque(false);
        sizePanel.add((Component)innerPanel, "North");
        return sizePanel;
    }

    private JPanel getTransparencyPanel() {
        JPanel innerPanel = new JPanel(new FlowLayout(1));
        innerPanel.setOpaque(false);
        JCheckBox transparent = new JCheckBox(ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.export.image.pngOnly"));
        transparent.setOpaque(false);
        transparent.setSelected(false);
        transparent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                AbstractSizeChooserPanel.this.transparency = 1 == event.getStateChange();
            }
        });
        innerPanel.add(transparent);
        return innerPanel;
    }

    private void addPresetListener() {
        this.presetComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                switch ((PresetEnum)((Object)e.getItem())) {
                    case Web: {
                        this.update(800);
                        break;
                    }
                    case Email: {
                        this.update(640);
                        break;
                    }
                    case High_Definition: {
                        this.update(1920);
                        break;
                    }
                    case Thumbnail: {
                        this.update(300);
                        break;
                    }
                    case Best: {
                        this.update(3500);
                        break;
                    }
                    case Custom: {
                        break;
                    }
                    default: {
                        Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"unexpected item selected ", e.getItem());
                    }
                }
            }

            private void update(int w) {
                AbstractSizeChooserPanel.this.widthSpinner.setValue(w);
                AbstractSizeChooserPanel.this.setHeightFromAspectRatio();
            }
        });
        this.presetComboBox.setSelectedItem((Object)PresetEnum.High_Definition);
        this.widthSpinner.setValue(1920);
        this.setHeightFromAspectRatio();
    }

    private void addSpinnerListeners() {
        final JSpinner.DefaultEditor heightSpinnerEditor = (JSpinner.DefaultEditor)this.heightSpinner.getEditor();
        heightSpinnerEditor.getTextField().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractSizeChooserPanel.this.presetComboBox.setSelectedItem((Object)PresetEnum.Custom);
                try {
                    heightSpinnerEditor.commitEdit();
                }
                catch (ParseException ex) {
                    Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"Couldn't commit edit", (Throwable)ex);
                }
                if (AbstractSizeChooserPanel.this.ratioCheckBox.isSelected()) {
                    AbstractSizeChooserPanel.this.setWidthFromAspectRatio();
                }
            }
        });
        final JSpinner.DefaultEditor widthSpinnerEditor = (JSpinner.DefaultEditor)this.widthSpinner.getEditor();
        widthSpinnerEditor.getTextField().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractSizeChooserPanel.this.presetComboBox.setSelectedItem((Object)PresetEnum.Custom);
                try {
                    widthSpinnerEditor.commitEdit();
                }
                catch (ParseException ex) {
                    Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"Couldn't commit edit", (Throwable)ex);
                }
                if (AbstractSizeChooserPanel.this.ratioCheckBox.isSelected()) {
                    AbstractSizeChooserPanel.this.setHeightFromAspectRatio();
                }
            }
        });
    }

    public final void setAspectRatio(int width, int height) {
        this.widthToHeightRatio = (double)width / (double)height;
        this.heightToWidthRatio = (double)height / (double)width;
        Logger.getLogger(AbstractSizeChooserPanel.class).debug((Object)("Ratios: h/w" + this.heightToWidthRatio + " w/h " + this.widthToHeightRatio));
        this.presetComboBox.setSelectedItem((Object)PresetEnum.High_Definition);
        this.widthSpinner.setValue(1920);
        this.setHeightFromAspectRatio();
    }

    private void setHeightFromAspectRatio() {
        if (this.heightToWidthRatio > 0.0) {
            this.heightSpinner.setValue((int)((double)((Integer)this.widthSpinner.getValue()).intValue() * this.heightToWidthRatio));
        }
    }

    private void setWidthFromAspectRatio() {
        if (this.widthToHeightRatio > 0.0) {
            this.widthSpinner.setValue((int)((double)((Integer)this.heightSpinner.getValue()).intValue() * this.widthToHeightRatio));
        }
    }

    private Box createRatioBox() {
        Box ratioBox = Box.createHorizontalBox();
        this.ratioCheckBox = new JCheckBox(ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.maintainsAspectRatio")){
            private static final long serialVersionUID = -8201420405552634093L;

            public void setSelected(boolean b) {
                if (b) {
                    AbstractSizeChooserPanel.this.heightSpinner.setEnabled(false);
                    AbstractSizeChooserPanel.this.setHeightFromAspectRatio();
                } else {
                    AbstractSizeChooserPanel.this.heightSpinner.setEnabled(true);
                }
                super.setSelected(b);
            }
        };
        this.ratioCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    AbstractSizeChooserPanel.this.heightSpinner.setEnabled(false);
                    AbstractSizeChooserPanel.this.setHeightFromAspectRatio();
                } else {
                    AbstractSizeChooserPanel.this.heightSpinner.setEnabled(true);
                }
            }
        });
        this.ratioCheckBox.setOpaque(false);
        this.ratioCheckBox.setSelected(true);
        ratioBox.add(this.ratioCheckBox);
        ratioBox.add(Box.createHorizontalGlue());
        return ratioBox;
    }

    private Box getDimensionBox(JSpinner spinner, String textKey) {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel(ImageExporterI18n.getLocalizedText(textKey));
        label.setPreferredSize(new Dimension(70, 20));
        box.add(label);
        CustomSpinnerNumberModel model = new CustomSpinnerNumberModel();
        model.setMinimum(Integer.valueOf(1));
        spinner.setModel(model);
        spinner.setEnabled(true);
        spinner.setValue(1);
        box.add(spinner);
        JLabel pixelLabel = new JLabel(ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.pixels"));
        box.add(Box.createHorizontalStrut(2));
        box.add(pixelLabel);
        box.setPreferredSize(new Dimension((int)label.getPreferredSize().getWidth() + 60 + (int)pixelLabel.getPreferredSize().getWidth() + 2, (int)box.getPreferredSize().getHeight()));
        return box;
    }

    public final Dimension getSelectedSize() {
        int width = Math.min(5000, (Integer)this.widthSpinner.getValue());
        int height = Math.min(5000, (Integer)this.heightSpinner.getValue());
        return new Dimension(width, height);
    }

    public final boolean getTransparencySetting() {
        return this.transparency;
    }

    protected final JSpinner getWidthSpinner() {
        return this.widthSpinner;
    }

    protected final JSpinner getHeightSpinner() {
        return this.heightSpinner;
    }

    protected final JCheckBox getRatioCheck() {
        return this.ratioCheckBox;
    }
}

