/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.v2.windows;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.PreferredWidthColumnGridLayout;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.ui.AbstractSizeChooserPanel;
import com.thinkbuzan.gaia.export.image.ui.CustomSpinnerNumberModel;
import com.thinkbuzan.gaia.export.image.ui.PresetEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ImageExportInnerPanel
extends JPanel {
    private static final String PRESET_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.preset");
    private static final String WIDTH_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.width");
    private static final String HEIGHT_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.height");
    private static final String ASPECT_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.maintainsAspectRatio");
    private static final String TRANSPARENT_BG_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.export.image.pngOnly");
    private static final String PIXELS_LABEL_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.pixels");
    private static final String IMAGE_TYPE_TEXT = ImageExporterI18n.getLocalizedText("com.thinkbuzan.i18n.imageexporter.ui.imageType");
    private static final int LABEL_FONT_STYLE = 0;
    private static final float LABEL_FONT_SIZE = 12.0f;
    private static final int OPTION_PADDING = 5;
    private JComboBox formatComboBox;
    private JComboBox presetComboBox;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;
    private JCheckBox aspectRatioCheckBox;
    private JCheckBox transparentBackgroundCheckBox;
    private transient double widthToHeightRatio = 0.0;
    private transient double heightToWidthRatio = 0.0;
    public static final int MAX_IMAGE_SIZE = 5000;
    private static final int BEST_WIDTH = 3500;
    private static final int HD_WIDTH = 1920;
    private static final int WEB_WIDTH = 800;
    private static final int EMAIL_WIDTH = 640;
    private static final int THUMBNAIL_WIDTH = 300;

    public ImageExportInnerPanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    public final boolean isBackgroundPaintedOptionSelected() {
        return !this.transparentBackgroundCheckBox.isSelected();
    }

    public final String getSelectedExtension() {
        if (SystemInfo.isAnyMac() && this.formatComboBox != null) {
            if (this.formatComboBox.getSelectedItem().toString().equals("pdf".toUpperCase())) {
                return "pdf";
            }
            if (this.formatComboBox.getSelectedItem().toString().equals("png".toUpperCase())) {
                return "png";
            }
            if (this.formatComboBox.getSelectedItem().toString().equals("jpg".toUpperCase())) {
                return "jpg";
            }
        }
        return null;
    }

    public final Dimension getSelectedSize() {
        int width = Math.min(5000, (Integer)this.widthSpinner.getValue());
        int height = Math.min(5000, (Integer)this.heightSpinner.getValue());
        return new Dimension(width, height);
    }

    public final void setSizeValues(int width, int height, boolean keepAspectRatio) {
        this.widthSpinner.setValue(width);
        this.heightSpinner.setValue(height);
        this.aspectRatioCheckBox.setSelected(keepAspectRatio);
    }

    private final JPanel createMainPanel() {
        LookAndFeel previous = UIManager.getLookAndFeel();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        if (SystemInfo.isAnyMac()) {
            panel.setLayout((LayoutManager)new PreferredWidthColumnGridLayout(6, 2, 5, 5));
            panel.add(this.createLabel(IMAGE_TYPE_TEXT));
            this.formatComboBox = new JComboBox();
            this.formatComboBox.setOpaque(false);
            this.formatComboBox.addItem("pdf".toUpperCase());
            this.formatComboBox.addItem("png".toUpperCase());
            this.formatComboBox.addItem("jpg".toUpperCase());
            this.formatComboBox.setUI(CoreUIFactory.getComboBoxUI());
            this.formatComboBox.setMinimumSize(new Dimension(150, this.formatComboBox.getMinimumSize().height));
            this.formatComboBox.setMaximumSize(new Dimension(150, this.formatComboBox.getMaximumSize().height));
            this.formatComboBox.setPreferredSize(new Dimension(150, this.formatComboBox.getPreferredSize().height));
            panel.add(this.formatComboBox);
        } else {
            panel.setLayout((LayoutManager)new PreferredWidthColumnGridLayout(5, 2, 5, 5));
        }
        panel.add(this.createLabel(PRESET_LABEL_TEXT));
        this.presetComboBox = new JComboBox();
        this.presetComboBox.setOpaque(false);
        for (PresetEnum presetEnum : PresetEnum.values()) {
            this.presetComboBox.addItem(presetEnum);
        }
        this.presetComboBox.setUI(CoreUIFactory.getComboBoxUI());
        this.presetComboBox.setMinimumSize(new Dimension(150, this.presetComboBox.getMinimumSize().height));
        this.presetComboBox.setMaximumSize(new Dimension(150, this.presetComboBox.getMaximumSize().height));
        this.presetComboBox.setPreferredSize(new Dimension(150, this.presetComboBox.getPreferredSize().height));
        panel.add(this.presetComboBox);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            Logger.getLogger(this.getClass()).warn((Object)"Failed to set look and feel");
        }
        panel.add(this.createLabel(WIDTH_LABEL_TEXT));
        this.widthSpinner = new JSpinner();
        this.widthSpinner.setOpaque(false);
        CustomSpinnerNumberModel widthModel = new CustomSpinnerNumberModel();
        widthModel.setMinimum(Integer.valueOf(1));
        this.widthSpinner.setModel(widthModel);
        this.widthSpinner.setEnabled(true);
        this.widthSpinner.setValue(1);
        JPanel widthPanel = new JPanel();
        widthPanel.setOpaque(false);
        widthPanel.setLayout(new BoxLayout(widthPanel, 0));
        widthPanel.add(this.widthSpinner);
        widthPanel.add(this.createLabel(PIXELS_LABEL_TEXT));
        panel.add(widthPanel);
        panel.add(this.createLabel(HEIGHT_LABEL_TEXT));
        this.heightSpinner = new JSpinner();
        this.heightSpinner.setOpaque(false);
        CustomSpinnerNumberModel heightModel = new CustomSpinnerNumberModel();
        heightModel.setMinimum(Integer.valueOf(1));
        this.heightSpinner.setModel(heightModel);
        this.heightSpinner.setEnabled(true);
        this.heightSpinner.setValue(1);
        JPanel heightPanel = new JPanel();
        heightPanel.setOpaque(false);
        heightPanel.setLayout(new BoxLayout(heightPanel, 0));
        heightPanel.add(this.heightSpinner);
        heightPanel.add(this.createLabel(PIXELS_LABEL_TEXT));
        panel.add(heightPanel);
        panel.add(this.createLabel(ASPECT_LABEL_TEXT));
        this.createRatioBox();
        panel.add(this.aspectRatioCheckBox);
        panel.add(this.createLabel(TRANSPARENT_BG_LABEL_TEXT));
        this.transparentBackgroundCheckBox = CoreUIFactory.createCheckBox((String)"");
        this.transparentBackgroundCheckBox.setOpaque(false);
        panel.add(this.transparentBackgroundCheckBox);
        this.addSpinnerListeners();
        this.addPresetListener();
        try {
            UIManager.setLookAndFeel(previous);
        }
        catch (Exception exc) {
            Logger.getLogger(this.getClass()).warn((Object)"Failed to set look and feel");
        }
        return panel;
    }

    private final JComponent createLabel(String label) {
        JLabel jlabel = new JLabel(label);
        jlabel.setOpaque(false);
        jlabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        JPanel alignPanel = new JPanel();
        alignPanel.setOpaque(false);
        alignPanel.setLayout(new FlowLayout(0));
        alignPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        alignPanel.add(jlabel);
        return alignPanel;
    }

    private void addSpinnerListeners() {
        final JSpinner.DefaultEditor heightSpinnerEditor = (JSpinner.DefaultEditor)this.heightSpinner.getEditor();
        heightSpinnerEditor.getTextField().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImageExportInnerPanel.this.presetComboBox.setSelectedItem((Object)PresetEnum.Custom);
                try {
                    heightSpinnerEditor.commitEdit();
                }
                catch (ParseException ex) {
                    Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"Couldn't commit edit", (Throwable)ex);
                }
                if (ImageExportInnerPanel.this.aspectRatioCheckBox.isSelected()) {
                    ImageExportInnerPanel.this.setWidthFromAspectRatio();
                }
            }
        });
        final JSpinner.DefaultEditor widthSpinnerEditor = (JSpinner.DefaultEditor)this.widthSpinner.getEditor();
        widthSpinnerEditor.getTextField().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImageExportInnerPanel.this.presetComboBox.setSelectedItem((Object)PresetEnum.Custom);
                try {
                    widthSpinnerEditor.commitEdit();
                }
                catch (ParseException ex) {
                    Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"Couldn't commit edit", (Throwable)ex);
                }
                if (ImageExportInnerPanel.this.aspectRatioCheckBox.isSelected()) {
                    ImageExportInnerPanel.this.setHeightFromAspectRatio();
                }
            }
        });
    }

    public final void setAspectRatio(int width, int height) {
        this.widthToHeightRatio = (double)width / (double)height;
        this.heightToWidthRatio = (double)height / (double)width;
        Logger.getLogger(AbstractSizeChooserPanel.class).debug((Object)("Ratios: h/w" + this.heightToWidthRatio + " w/h " + this.widthToHeightRatio));
        this.presetComboBox.setSelectedItem((Object)PresetEnum.High_Definition);
        this.widthSpinner.setValue(1920);
        this.setHeightFromAspectRatio();
    }

    private void setHeightFromAspectRatio() {
        if (this.heightToWidthRatio > 0.0) {
            this.heightSpinner.setValue((int)((double)((Integer)this.widthSpinner.getValue()).intValue() * this.heightToWidthRatio));
        }
    }

    private void setWidthFromAspectRatio() {
        if (this.widthToHeightRatio > 0.0) {
            this.widthSpinner.setValue((int)((double)((Integer)this.heightSpinner.getValue()).intValue() * this.widthToHeightRatio));
        }
    }

    private void addPresetListener() {
        this.presetComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                switch ((PresetEnum)((Object)e.getItem())) {
                    case Web: {
                        this.update(800);
                        break;
                    }
                    case Email: {
                        this.update(640);
                        break;
                    }
                    case High_Definition: {
                        this.update(1920);
                        break;
                    }
                    case Thumbnail: {
                        this.update(300);
                        break;
                    }
                    case Best: {
                        this.update(3500);
                        break;
                    }
                    case Custom: {
                        break;
                    }
                    default: {
                        Logger.getLogger(AbstractSizeChooserPanel.class).warn((Object)"unexpected item selected ", e.getItem());
                    }
                }
            }

            private void update(int w) {
                ImageExportInnerPanel.this.widthSpinner.setValue(w);
                ImageExportInnerPanel.this.setHeightFromAspectRatio();
            }
        });
        this.presetComboBox.setSelectedItem((Object)PresetEnum.High_Definition);
        this.widthSpinner.setValue(1920);
        this.setHeightFromAspectRatio();
    }

    private void createRatioBox() {
        JCheckBox cb = CoreUIFactory.createCheckBox((String)"");
        this.aspectRatioCheckBox = new JCheckBox(){
            private static final long serialVersionUID = -8201420405552634093L;

            public void setSelected(boolean b) {
                if (b) {
                    ImageExportInnerPanel.this.heightSpinner.setEnabled(false);
                    ImageExportInnerPanel.this.setHeightFromAspectRatio();
                } else {
                    ImageExportInnerPanel.this.heightSpinner.setEnabled(true);
                }
                super.setSelected(b);
            }
        };
        this.aspectRatioCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    ImageExportInnerPanel.this.heightSpinner.setEnabled(false);
                    ImageExportInnerPanel.this.setHeightFromAspectRatio();
                } else {
                    ImageExportInnerPanel.this.heightSpinner.setEnabled(true);
                }
            }
        });
        this.aspectRatioCheckBox.setUI(cb.getUI());
        if (!SystemInfo.isAnyMac()) {
            this.aspectRatioCheckBox.setOpaque(false);
            this.aspectRatioCheckBox.setBorder(BorderFactory.createEmptyBorder());
        }
        this.aspectRatioCheckBox.setSelected(true);
    }
}

