/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.v2.windows;

import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.FileType;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.image.i18n.ImageExporterI18n;
import com.thinkbuzan.gaia.export.image.v2.windows.ImageExportInnerPanel;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.gaia.export.image.writers.JPEGWriter;
import com.thinkbuzan.gaia.export.image.writers.PDFWriter;
import com.thinkbuzan.gaia.export.image.writers.PNGWriter;
import com.thinkbuzan.pascal.services.editor.IPainter;
import com.thinkbuzan.phoenix.licensing.LicenseService;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

public class WindowsImageExporter
implements IExporter {
    private static final String NAME_KEY = "com.thinkbuzan.i18n.common.windows.rt.imagefile.title";
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String PDF = "pdf";
    protected static final String[] JPEG_FILE_EXT = new String[]{"jpg", "jpeg"};
    protected static final String[] PNG_FILE_EXT = new String[]{"png"};
    protected static final String[] PDF_FILE_EXT = new String[]{"pdf"};
    protected static final String JPEG_DESC = "JPEG File (*.jpeg, *.jpg)";
    protected static final String PNG_DESC = "PNG File (*.png)";
    protected static final String PDF_DESC = "PDF File (*.pdf)";
    private final transient Map<String, List<String>> descExtMap = new HashMap<String, List<String>>();
    private final transient IFileType fileType;
    private final transient EditorManager editorManagerRef;
    private final transient PluginLicenseService pluginLicenseServiceRef;
    private final transient PreferencesService preferenceServiceRef;
    private ImageExportInnerPanel imageExportPanel;

    public WindowsImageExporter(EditorManager editorManager, PluginLicenseService licenseServiceIn, PreferencesService preferenceServiceIn) {
        this.editorManagerRef = editorManager;
        this.pluginLicenseServiceRef = licenseServiceIn;
        this.preferenceServiceRef = preferenceServiceIn;
        this.descExtMap.put(JPEG_DESC, Arrays.asList(JPEG_FILE_EXT));
        this.descExtMap.put(PNG_DESC, Arrays.asList(PNG_FILE_EXT));
        this.descExtMap.put(PDF_DESC, Arrays.asList(PDF_FILE_EXT));
        this.fileType = new FileType(Arrays.asList(JPEG_DESC, PNG_DESC, PDF_DESC), this.descExtMap);
        this.imageExportPanel = new ImageExportInnerPanel();
    }

    public String getId() {
        return "com.thinkbuzan.gaia.export.image";
    }

    public String getName() {
        return ImageExporterI18n.getLocalizedText(NAME_KEY);
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent getComponent() {
        IEditorComponent editorComponent = null;
        try {
            editorComponent = this.editorManagerRef.getCurrentEditorComponent();
        }
        catch (IllegalArgumentException ex) {
            editorComponent = null;
        }
        IPainter painter = this.createPainter(editorComponent);
        Dimension size = painter.getPaintBounds().getBounds().getSize();
        this.imageExportPanel.setAspectRatio(size.width, size.height);
        return this.imageExportPanel;
    }

    public IFileType getOutputFileType() {
        return this.fileType;
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.IMAGE;
    }

    public IExporter.LicenseState getLicenseState() {
        return IExporter.LicenseState.full;
    }

    public void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener) {
        this.export(editorComponent, null, outputFile, exporterListener);
    }

    public void export(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn, Object ... objects) {
        if (objects.length == 1 && objects[0] instanceof BufferedImage) {
            this.export(editorComponent, (BufferedImage)objects[0], outputFileIn, exporterListenerIn);
        } else {
            if (this.imageExportPanel != null) {
                this.getComponent();
                int imageWidth = 0;
                int imageHeight = 0;
                boolean keepAspect = false;
                if (objects.length > 0 && objects[0] instanceof Integer) {
                    imageWidth = (Integer)objects[0];
                }
                if (objects.length > 1 && objects[1] instanceof Integer) {
                    imageHeight = (Integer)objects[1];
                    this.imageExportPanel.setSizeValues(imageWidth, imageHeight, keepAspect);
                }
                if (objects.length > 2 && objects[2] instanceof Boolean) {
                    keepAspect = (Boolean)objects[2];
                    this.imageExportPanel.setSizeValues(imageWidth, imageHeight, keepAspect);
                }
            }
            this.export(editorComponent, outputFileIn, exporterListenerIn);
        }
    }

    private void export(IEditorComponent editorComponent, BufferedImage image, File outputFile, IExporterListener exporterListener) {
        this.validateExport(editorComponent, outputFile, exporterListener);
        float progress = 0.1f;
        if (image == null) {
            File updatedOutputFile = outputFile;
            updatedOutputFile = new File(updatedOutputFile.getAbsolutePath());
            if (this.imageExportPanel.getSelectedExtension() != null) {
                String fileWithoutExtension = updatedOutputFile.getAbsolutePath().substring(0, updatedOutputFile.getAbsolutePath().lastIndexOf(46));
                updatedOutputFile = new File(fileWithoutExtension + "." + this.imageExportPanel.getSelectedExtension());
            }
            String type = this.getFileType(updatedOutputFile);
            ImageWriter writer = this.getWriter(type);
            exporterListener.exportProgress(0.1f);
            IPainter painter = this.createPainter(editorComponent);
            Dimension selectedSize = this.imageExportPanel.getSelectedSize();
            if (writer instanceof PNGWriter) {
                painter.setBackgroundPainted(this.imageExportPanel.isBackgroundPaintedOptionSelected());
            }
            writer.write(updatedOutputFile, painter, type, selectedSize);
            exporterListener.exportProgress(1.0f);
        } else {
            String type = this.getFileType(outputFile);
            ImageWriter writer = this.getWriter(type);
            exporterListener.exportProgress(0.1f);
            writer.write(outputFile, image, type);
            exporterListener.exportProgress(1.0f);
        }
    }

    private IPainter createPainter(IEditorComponent editorComponent) {
        IPainter painter = editorComponent.createPainter(true, false);
        painter.setBackgroundPainted(true);
        return painter;
    }

    private final ImageWriter getWriter(String filetype) {
        ImageWriter writer = JPG.equalsIgnoreCase(filetype) || JPEG.equalsIgnoreCase(filetype) ? new JPEGWriter((LicenseService)this.pluginLicenseServiceRef) : (PDF.equalsIgnoreCase(filetype) ? new PDFWriter(this.preferenceServiceRef) : new PNGWriter((LicenseService)this.pluginLicenseServiceRef));
        return writer;
    }

    private final String getFileType(File outputFile) {
        String fileName = outputFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (this.isValidExtension(JPEG_FILE_EXT, extension) || this.isValidExtension(PNG_FILE_EXT, extension) || this.isValidExtension(PDF_FILE_EXT, extension)) {
            return extension;
        }
        return null;
    }

    private boolean isValidExtension(String[] validExt, String extension) {
        for (String ext : validExt) {
            if (!extension.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    private void validateExport(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn) {
        if (editorComponent == null) {
            throw new IllegalArgumentException("Editor component can't be null!");
        }
        if (outputFileIn == null) {
            throw new IllegalArgumentException("Out put file can't be null!");
        }
        if (exporterListenerIn == null) {
            throw new IllegalArgumentException("Exporter listener can't be null!");
        }
    }
}

