/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.writers;

import com.thinkbuzan.gaia.export.image.resource.ResourceManager;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.pascal.services.editor.IPainter;
import com.thinkbuzan.phoenix.licensing.LicenseService;
import com.thinkbuzan.phoenix.licensing.LicenseType;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractImageWriter
implements ImageWriter {
    private static final transient Logger LOGGER = Logger.getLogger(AbstractImageWriter.class);
    private static final double WATERMARK_SCALE_FACTOR = 3.0;
    private final transient LicenseService licenseService;

    public AbstractImageWriter(LicenseService licenseServiceIn) {
        this.licenseService = licenseServiceIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedImage createCachingImage(IPainter painter, String fileType, Dimension size) {
        AbstractImageWriter.validateCreateCachingImage(painter, size);
        Rectangle2D paintBounds = painter.getPaintBounds();
        int width = size.width;
        int height = size.height;
        BufferedImage img = "jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 2);
        double scaleX = (double)size.width / paintBounds.getWidth();
        double scaleY = (double)size.height / paintBounds.getHeight();
        Graphics2D g2d = img.createGraphics();
        try {
            if (!"png".equalsIgnoreCase(fileType) || painter.isBackgroundPainted()) {
                g2d.setColor(painter.getBackgroundColor());
                g2d.fillRect(0, 0, width, height);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setClip(null);
            g2d.scale(scaleX, scaleY);
            painter.paint(g2d);
            this.needWaterMark(g2d, size, scaleX, scaleY);
        }
        finally {
            g2d.dispose();
        }
        return img;
    }

    private static void validateCreateCachingImage(IPainter painter, Dimension size) {
        if (painter == null) {
            throw new IllegalArgumentException("first parameter can't be null");
        }
        if (size == null) {
            throw new IllegalArgumentException("second parameter is not valid, try using -1 or some positive value instead");
        }
    }

    public abstract boolean writeImage(File var1, String var2, RenderedImage var3);

    public final boolean write(File file, IPainter painter, String fileType, Dimension size) {
        this.validateWrite(file, painter, fileType);
        if (size == null) {
            throw new IllegalArgumentException("size can not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("write(%s, %s, %s, %s)", file, painter, fileType, size));
        }
        boolean val = false;
        BufferedImage image = this.createCachingImage(painter, fileType, size);
        if (image != null) {
            val = this.writeImage(file, fileType, image);
        }
        return val;
    }

    public final boolean write(File file, BufferedImage image, String fileType) {
        this.validateWrite(file, image, fileType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("write(%s, %s, %s)", file, image, fileType));
        }
        return this.writeImage(file, fileType, image);
    }

    private void validateWrite(File file, IPainter painter, String fileType) {
        if (file == null || fileType == null || painter == null) {
            throw new IllegalArgumentException(String.format("NULL parameter not allowed! file=[%s], painter=[%s], fileType=[%s]", file, painter, fileType));
        }
    }

    private void validateWrite(File file, RenderedImage image, String fileType) {
        if (file == null || fileType == null || image == null) {
            throw new IllegalArgumentException(String.format("NULL parameter not allowed! file=[%s], image=[%s], fileType=[%s]", file, image, fileType));
        }
    }

    private void needWaterMark(Graphics2D graphics, Dimension size, double scaleX, double scaleY) {
        LicenseType type = this.licenseService.getLicense(false).getType();
        if (LicenseType.basic.equals((Object)type) || LicenseType.trial.equals((Object)type)) {
            BufferedImage image = null;
            try {
                image = ResourceManager.getWaterMarkImage(type);
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Issue when exporting: log and continue", (Throwable)ex);
            }
            if (image != null) {
                graphics.scale(1.0 / scaleX, 1.0 / scaleY);
                double newScaleX = (double)size.width / 3.0;
                double newScaleY = (double)image.getHeight() * newScaleX / (double)image.getWidth();
                Image resizedImage = image.getScaledInstance((int)newScaleX, (int)newScaleY, 4);
                graphics.drawImage(resizedImage, (int)((double)size.width - newScaleX) - 5, (int)((double)size.height - newScaleY) - 5, null);
            }
        }
    }
}

