/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.writers;

import com.thinkbuzan.gaia.export.image.writers.AbstractImageWriter;
import com.thinkbuzan.phoenix.licensing.LicenseService;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class JPEGWriter
extends AbstractImageWriter {
    public JPEGWriter(LicenseService licenseServiceIn) {
        super(licenseServiceIn);
    }

    public boolean writeImage(File selectedFile, String imageType, RenderedImage img) {
        this.validateWriteImage(selectedFile, imageType, img);
        boolean writeSuccess = true;
        try {
            writeSuccess = ImageIO.write(img, "jpg", selectedFile);
        }
        catch (IOException ex) {
            writeSuccess = false;
            Logger.getLogger(JPEGWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return writeSuccess;
    }

    private void validateWriteImage(File file, String type, RenderedImage img) {
        if (file == null || type == null || img == null) {
            throw new IllegalArgumentException("NULL parameter not allowed!");
        }
    }
}

