/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.image.writers;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.gaia.export.image.writers.ImageWriter;
import com.thinkbuzan.pascal.services.editor.IPainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFWriter
implements ImageWriter {
    private static final transient Logger LOGGER = Logger.getLogger(PDFWriter.class);
    private static final String TEMP_DIR = "java.io.tmpdir";
    private static final String ERROR_MESSAGE = "Error exporting image as PDF";
    private static final String CREATOR = "iMindMap";
    private static final String BRAINSTORM_PAINTER_CLASS_NAME = "com.thinkbuzan.phoenix.brainstorm.painter.Painter";
    private final transient PreferencesService preferenceServiceRef;

    public PDFWriter(PreferencesService preferenceServiceIn) {
        this.preferenceServiceRef = preferenceServiceIn;
    }

    public final boolean write(File outputFile, IPainter painter, String fileType, Dimension selectedSize) {
        try {
            this.writeFileAtSize(outputFile, painter, fileType, selectedSize);
        }
        catch (Exception e) {
            LOGGER.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
        return true;
    }

    public final boolean writeFile(File file, final IPainter painter, String fileType) {
        Dimension painterDimensions = new Dimension((int)painter.getPaintBounds().getWidth(), (int)painter.getPaintBounds().getHeight());
        ExportPainter exportPainter = new ExportPainter(){

            public void paint(PDFGraphics2D graphics) {
                painter.paint((Graphics2D)graphics);
            }
        };
        return this.doExport(file, exportPainter, fileType, painterDimensions);
    }

    public final boolean writeFileAtSize(File file, final IPainter painter, String fileType, final Dimension size) {
        if (painter.getClass().getName().equals(BRAINSTORM_PAINTER_CLASS_NAME)) {
            ExportPainter exportPainter = new ExportPainter(){

                public void paint(PDFGraphics2D graphics) {
                    BufferedImage brainstormImage = PDFWriter.this.getBrainstormImage(painter, size);
                    if (brainstormImage != null) {
                        graphics.drawImage((Image)brainstormImage, 0, 0, null);
                    }
                }
            };
            return this.doExport(file, exportPainter, fileType, size);
        }
        Rectangle2D paintBounds = painter.getPaintBounds();
        final double scaleX = painter.getScale() * ((double)size.width / paintBounds.getWidth());
        final double scaleY = painter.getScale() * ((double)size.height / paintBounds.getHeight());
        Preferences userPreferences = this.preferenceServiceRef.getCurrentUserPreferences();
        if (userPreferences == null || !userPreferences.getBoolean("com.thinkbuzan.gaia.useAlternatePDF", false)) {
            ExportPainter exportPainter = new ExportPainter(){

                public void paint(PDFGraphics2D graphics) {
                    graphics.scale(scaleX, scaleY);
                    painter.paint((Graphics2D)graphics);
                }
            };
            return this.doExport(file, exportPainter, fileType, size);
        }
        PDDocument document = new PDDocument();
        BufferedImage bimg = new BufferedImage(size.width, size.height, 2);
        Graphics2D graphics = (Graphics2D)bimg.getGraphics();
        graphics.scale(scaleX, scaleY);
        painter.paint(graphics);
        float width = bimg.getWidth();
        float height = bimg.getHeight();
        PDPage page = new PDPage(new PDRectangle(width, height));
        document.addPage(page);
        try {
            PDJpeg img = new PDJpeg(document, bimg);
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            contentStream.drawImage((PDXObjectImage)img, 0.0f, 0.0f);
            contentStream.close();
            document.save(file);
            document.close();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to export", (Throwable)e);
            return false;
        }
        return true;
    }

    private final BufferedImage getBrainstormImage(IPainter painter, Dimension maximumSize) {
        BufferedImage image = null;
        try {
            Rectangle2D size = painter.getPaintBounds();
            double xRatio = size.getWidth() / (double)maximumSize.width;
            double yRatio = size.getHeight() / (double)maximumSize.height;
            double scale = 1.0;
            double scaleX = 1.0 / xRatio;
            double scaleY = 1.0 / yRatio;
            scale = xRatio > yRatio ? scaleX : scaleY;
            painter.setScale(scale);
            size = painter.getPaintBounds();
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            int imageWidth = Math.max(1, (int)Math.ceil(maximumSize.getWidth()));
            int imageHeight = Math.max(1, (int)Math.ceil(maximumSize.getHeight()));
            try {
                image = new BufferedImage(imageWidth, imageHeight, 2);
                Graphics2D graphics = (Graphics2D)image.getGraphics();
                double xScale = scaleX / scale;
                double yScale = scaleY / scale;
                graphics.scale(xScale, yScale);
                painter.paint(graphics);
                graphics.dispose();
            }
            catch (Exception exc) {
                LOGGER.error((Object)"PDFWriter: Failed to generate brainstorm image ", (Throwable)exc);
            }
            catch (Error err) {
                LOGGER.error((Object)"PDFWriter: Failed to generate brainstorm image ", (Throwable)err);
            }
        }
        catch (Exception allEx) {
            LOGGER.error((Object)"PDFWriter: getBrainstormImage Fail ", (Throwable)allEx);
        }
        return image;
    }

    public final boolean write(File file, final BufferedImage image, String fileType) {
        try {
            Dimension size = new Dimension(image.getWidth(), image.getHeight());
            ExportPainter exportPainter = new ExportPainter(){

                public void paint(PDFGraphics2D graphics) {
                    graphics.drawImage((Image)image, 0, 0, null);
                }
            };
            this.doExport(file, exportPainter, fileType, size);
        }
        catch (Exception e) {
            LOGGER.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doExport(File file, ExportPainter painter, String fileType, Dimension size) {
        block36: {
            Object v0;
            FileOutputStream out = null;
            String tempDir = System.getProperty(TEMP_DIR);
            File tempFile = new File(tempDir, UUID.randomUUID().toString());
            out = new FileOutputStream(tempFile);
            UserProperties props = (UserProperties)PDFGraphics2D.getDefaultProperties();
            props.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
            props.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, size);
            if (size.width > size.height) {
                props.setProperty(PDFGraphics2D.ORIENTATION, "Landscape");
            } else {
                props.setProperty(PDFGraphics2D.ORIENTATION, "Portrait");
            }
            PDFGraphics2D.setDefaultProperties((Properties)props);
            PDFGraphics2D graphics = new PDFGraphics2D((OutputStream)out, size);
            graphics.setCreator(CREATOR);
            graphics.startExport();
            painter.paint(graphics);
            graphics.endExport();
            Object var11_11 = null;
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (!file.exists() && !file.createNewFile()) {
                    LOGGER.warn((Object)("Could not create file = " + file.getAbsolutePath()));
                }
            }
            catch (IOException e2) {
                LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e2);
            }
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                try {
                    source = new FileInputStream(tempFile).getChannel();
                    destination = new FileOutputStream(file).getChannel();
                    ((FileChannel)destination).transferFrom(source, 0L, source.size());
                    v0 = null;
                }
                catch (IOException e3) {
                    LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e3);
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var16_26 = v0;
            try {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
                break block36;
            }
            catch (IOException e4) {
                LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e4);
            }
            break block36;
            {
                catch (FileNotFoundException e) {
                    Object v1;
                    LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e);
                    Object var11_12 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        if (!file.exists() && !file.createNewFile()) {
                            LOGGER.warn((Object)("Could not create file = " + file.getAbsolutePath()));
                        }
                    }
                    catch (IOException e2) {
                        LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e2);
                    }
                    source = null;
                    destination = null;
                    try {
                        try {
                            source = new FileInputStream(tempFile).getChannel();
                            destination = new FileOutputStream(file).getChannel();
                            ((FileChannel)destination).transferFrom(source, 0L, source.size());
                            v1 = null;
                        }
                        catch (IOException e3) {
                            LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e3);
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var16_27 = v1;
                    try {
                        if (source != null) {
                            source.close();
                        }
                        if (destination != null) {
                            destination.close();
                        }
                        break block36;
                    }
                    catch (IOException e4) {
                        LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e4);
                    }
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var11_13 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (!file.exists() && !file.createNewFile()) {
                        LOGGER.warn((Object)("Could not create file = " + file.getAbsolutePath()));
                    }
                }
                catch (IOException e2) {
                    LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e2);
                }
                source = null;
                destination = null;
                try {
                    try {
                        source = new FileInputStream(tempFile).getChannel();
                        destination = new FileOutputStream(file).getChannel();
                        ((FileChannel)destination).transferFrom(source, 0L, source.size());
                        v2 = null;
                    }
                    catch (IOException e3) {
                        LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e3);
                        v2 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var16_28 = v2;
                try {
                    if (source != null) {
                        source.close();
                    }
                    if (destination != null) {
                        destination.close();
                    }
                }
                catch (IOException e4) {
                    LOGGER.warn((Object)ERROR_MESSAGE, (Throwable)e4);
                }
                throw throwable;
            }
        }
        return true;
    }

    private static interface ExportPainter {
        public void paint(PDFGraphics2D var1);
    }
}

