/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.contacts.ui;

import com.thinkbuzan.pascal.contacts.osgi.ServiceManager;
import com.thinkbuzan.pascal.contacts.resources.Interface;
import com.thinkbuzan.pascal.contacts.ui.HeaderFactory;
import com.thinkbuzan.pascal.contacts.ui.components.AbstractContactListPanel;
import com.thinkbuzan.pascal.contacts.ui.components.IBusy;
import com.thinkbuzan.pascal.services.contacts.IPoseidonObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContactList
extends JPanel {
    private static final long serialVersionUID = -5177226815714663263L;
    private final List<IPoseidonObject> a;
    private final List<IPoseidonObject> b;
    private final transient List<InteractionListener> c;
    private transient int d;
    private final transient AbstractContactListPanel e;
    private static final Color f = new Color(0xE2E2E2);
    private final transient List<AbstractContactListPanel.ComponentSelectionListener> g;
    private final transient List<IBusy> h;
    public static int i;

    public AbstractContactList(AbstractContactListPanel abstractContactListPanel) {
        int n = i;
        this.a = new ArrayList<IPoseidonObject>();
        this.b = new ArrayList<IPoseidonObject>();
        this.d = -1;
        this.g = new ArrayList<AbstractContactListPanel.ComponentSelectionListener>();
        this.h = new ArrayList<IBusy>();
        this.e = abstractContactListPanel;
        this.c = new ArrayList<InteractionListener>();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        if (ServiceManager.j) {
            i = ++n;
        }
    }

    public final void addSelectionListener(AbstractContactListPanel.ComponentSelectionListener componentSelectionListener) {
        this.g.add(componentSelectionListener);
    }

    public final void notifySelectedItem(JComponent jComponent) {
        int n = i;
        for (AbstractContactListPanel.ComponentSelectionListener componentSelectionListener : this.g) {
            componentSelectionListener.componentSelected(jComponent);
            if (n == 0) continue;
        }
    }

    protected final MouseAdapter a(final IPoseidonObject iPoseidonObject) {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (AbstractContactList.this.a.size() > 0) {
                    AbstractContactList.this.setSelectedIndex(AbstractContactList.this.a.indexOf(iPoseidonObject));
                }
                this.a();
            }

            private void a() {
                int n = i;
                for (InteractionListener interactionListener : AbstractContactList.this.c) {
                    interactionListener.itemClicked(iPoseidonObject);
                    if (n == 0) continue;
                }
            }
        };
    }

    public final void addInteractionListener(InteractionListener interactionListener) {
        this.c.add(interactionListener);
    }

    public final synchronized void setAllEntities(List<? extends IPoseidonObject> list) {
        this.b.clear();
        if (list != null) {
            this.b.addAll(list);
        }
    }

    public final List<? extends IPoseidonObject> getAllEntities() {
        return new CopyOnWriteArrayList<IPoseidonObject>(this.b);
    }

    public synchronized void setEntities(List<? extends IPoseidonObject> list) {
        this.a.clear();
        if (list != null) {
            this.a.addAll(list);
        }
    }

    public final void setSelectedIndex(int n) {
        this.d = n;
    }

    public final void clear() {
        this.a.clear();
        this.b.clear();
        this.removeAll();
    }

    public final void addBusyListener(IBusy iBusy) {
        this.h.add(iBusy);
    }

    public final void setBusy(boolean bl) {
        int n = i;
        for (IBusy iBusy : this.h) {
            iBusy.busy(bl);
            if (n == 0) continue;
        }
    }

    protected final JPanel a(String string) {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -4907189412969790466L;

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Interface.SEPERATOR_COLOR);
                graphics2D.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBackground(f);
        jPanel.add(HeaderFactory.getHeader(string));
        jPanel.add(Box.createHorizontalGlue());
        this.add(jPanel);
        return jPanel;
    }

    public final void clearFilter() {
        this.setEntities(this.b);
        this.revalidate();
    }

    public final void filter(String string) {
        int n = i;
        ArrayList<IPoseidonObject> arrayList = new ArrayList<IPoseidonObject>();
        for (IPoseidonObject iPoseidonObject : this.getAllEntities()) {
            if (iPoseidonObject.getName().contains(string)) {
                arrayList.add(iPoseidonObject);
            }
            if (n == 0) continue;
        }
        this.setEntities(arrayList);
    }

    public static interface InteractionListener {
        public void itemClicked(IPoseidonObject var1);
    }
}

