/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.opml;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.importer.opml.OPMLImporter;
import com.thinkbuzan.gaia.importer.opml.license.BundleLicenser;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.ImportManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public final void start(BundleContext context) {
        this.registerOPMLImporter(context);
    }

    private void registerOPMLImporter(BundleContext context) {
        BundleLicenser licenser = new BundleLicenser(context);
        I18n i18n = this.getI18n(context);
        OSGiService importManagerService = new OSGiService(context, ImportManager.class);
        if (licenser.isOpmlImportLicensed()) {
            ((ImportManager)importManagerService.get()).register((IImporter)new OPMLImporter(i18n));
        } else {
            ((ImportManager)importManagerService.get()).registerUnlicensed((IImporter)new OPMLImporter(i18n));
        }
        importManagerService.close();
    }

    private I18n getI18n(BundleContext context) {
        I18n i18n = (I18n)new OSGiService(context, I18n.class).get();
        i18n.register(new ITextBundle(){

            public final ClassLoader getClassLoader() {
                return Activator.class.getClassLoader();
            }

            public final String getPropertyFileBaseName() {
                return "/i18nproperties/OPMLImporterMessages";
            }
        });
        return i18n;
    }

    public final void stop(BundleContext context) {
    }
}

