/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.opml;

import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.utilities.html.HTMLUtilities;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.AddRelationshipAction;
import com.thinkbuzan.gaia.editor.actions.BeginModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.EndModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.RunFullLayoutAction;
import com.thinkbuzan.gaia.editor.actions.SetIconsAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutEnabledAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.HyperLink;
import com.thinkbuzan.gaia.entities.HyperLinkType;
import com.thinkbuzan.gaia.entities.Notes;
import com.thinkbuzan.gaia.entities.Task;
import com.thinkbuzan.gaia.importer.opml.resources.ResourceManager;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.IImporterListener;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class OPMLImporter
implements IImporter {
    private static final String NAME = "name";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String COMPLETION = "completion";
    private static final String PRIORITY = "priority";
    private static final String NOTES2 = "notes";
    private static final String TASK = "task";
    private static final String ID = "ID";
    private static final String YES = "yes";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    private static final String TEXT = "text";
    private static final String OUTLINE = "outline";
    private static final String TITLE = "title";
    private static final String BODY = "body";
    private static final String HEAD = "head";
    private static final String LINK = "link";
    private static final String RSS = "rss";
    private static final String NOTES = "note";
    private static final String RELATIONSHIP = "relationship";
    private static final String BOX_BRANCH = "boxbranch";
    private static final String URL = "url";
    private static final String IMM5_MAP = "iMindMap5 Map";
    private transient mmIStructureCell currentParentCell;
    private transient mmIStructureCell floatingIdea;
    private transient int progressCount = 0;
    private transient int currentProgress = 0;
    private transient IImporterListener opmlListener;
    private transient IEditorComponent editorComponent;
    private static String LABEL;
    private static String DESCRIPTION;
    private static final List<String> EXTENSIONS;
    private static final Logger LOGGER;
    private static final Object ICONS;
    private static String ERROR_MESSAGE;
    private Map<String, mmIStructureCell> rMap = new HashMap<String, mmIStructureCell>();

    public OPMLImporter(I18n i18n) {
        LABEL = i18n.getLocalizedText("com.thinkbuzan.i18n.opmlimporter.importOPMLFile");
        DESCRIPTION = i18n.getLocalizedText("com.thinkbuzan.i18n.opmlimporter.opmlFiles");
        ERROR_MESSAGE = i18n.getLocalizedText("com.thinkbuzan.i18n.opmlimporter.errorMessage");
    }

    public final void importFile(File file, IEditorComponent editorComponentIn, IImporterListener importListenerIn) {
        this.validateImportImpl(file, editorComponentIn, importListenerIn);
        this.clearAllVariable();
        this.opmlListener = importListenerIn;
        this.editorComponent = editorComponentIn;
        SAXBuilder sb = new SAXBuilder();
        try {
            this.editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(false));
            this.editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
            Document doc = sb.build(file);
            Element root = doc.getRootElement();
            this.checkElement(root);
            Element head = root.getChild(HEAD);
            Element body = root.getChild(BODY);
            this.initProgress(head, body);
            this.checkHeadTitle(head);
            this.parseBodyElement(body);
            this.editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
            this.editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(true));
            this.editorComponent.runAction((AbstractEditorAction)new RunFullLayoutAction());
        }
        catch (Exception exception) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Caught Exception", (Throwable)exception);
            }
            this.opmlListener.importErrorOccurred(ERROR_MESSAGE);
        }
    }

    private void clearAllVariable() {
        this.currentParentCell = null;
        this.floatingIdea = null;
        this.progressCount = 0;
        this.currentProgress = 0;
    }

    private void checkHeadTitle(Element head) {
        Element title;
        boolean createIdea = false;
        String titleText = "";
        if (head == null || head.getChildren() == null || head.getChildren().size() == 0) {
            createIdea = true;
        } else if (!(head.getChildren() == null || head.getChildren().size() <= 0 || (title = head.getChild(TITLE)) != null && title.getText() != null && title.getText().equals(IMM5_MAP))) {
            titleText = title == null || title.getText() == null ? "" : HTMLUtilities.removeHTML((String)title.getText());
            createIdea = true;
        }
        if (createIdea) {
            this.floatingIdea = (mmIStructureCell)this.editorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(titleText));
        }
    }

    private void parseBodyElement(Element bodyElement) {
        this.checkElement(bodyElement);
        List outlineList = bodyElement.getChildren(OUTLINE);
        if (this.floatingIdea == null) {
            for (Element e : outlineList) {
                this.createFloatingIdeaFromBody(e);
                this.importProgress();
            }
        } else {
            for (Element e : outlineList) {
                this.currentParentCell = this.floatingIdea;
                this.parseOutlineElement(e);
                this.importProgress();
            }
        }
    }

    private void importProgress() {
        ++this.currentProgress;
        float progress = (float)this.currentProgress * 1.0f / (float)this.progressCount;
        float tempNum = 100.0f;
        progress = Math.round(progress * 100.0f);
        this.opmlListener.importProgress(progress);
    }

    private void parseOutlineElement(Element outlineElement) {
        if (outlineElement.getAttributeValue(TYPE) == null) {
            this.parseOutlineElementBranch(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(BOX_BRANCH)) {
            this.parseOutlineElementBoxBranch(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(NOTES)) {
            this.parseOutlineElementNotes(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(RELATIONSHIP)) {
            this.parseOutlineElementRelationships(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(TASK)) {
            this.parseOutlineElementTask(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(ICONS)) {
            this.parseOutlineElementIcons(outlineElement);
        } else if (outlineElement.getAttributeValue(TYPE).equals(LINK) || outlineElement.getAttributeValue(TYPE).equals(RSS)) {
            if (outlineElement.getAttributeValue(NAME) != null || outlineElement.getAttributeValue(TEXT) != null || outlineElement.getAttributeValue(TITLE) != null) {
                this.parseOutlineElementBranchAndLink(outlineElement);
            } else {
                this.parseOutlineElementLink(outlineElement);
            }
        }
    }

    private void parseOutlineElementBranch(Element outlineElement) {
        String outlineText = outlineElement.getAttributeValue(NAME);
        if (outlineText == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineText = outlineElement.getAttributeValue(TITLE);
        } else if (outlineText == null && outlineElement.getAttributeValue(TEXT) != null) {
            outlineText = outlineElement.getAttributeValue(TEXT);
        } else if (outlineText == null) {
            outlineText = "";
        }
        outlineText = HTMLUtilities.removeHTML((String)outlineText);
        mmIStructureCell addedBranch = (mmIStructureCell)this.editorComponent.runAction((AbstractEditorAction)new AddBranchAction(this.currentParentCell, BranchType.BRANCH, outlineText));
        List outlineList = outlineElement.getChildren(OUTLINE);
        for (Element e : outlineList) {
            this.currentParentCell = addedBranch;
            this.parseOutlineElement(e);
            this.importProgress();
        }
    }

    private void parseOutlineElementBoxBranch(Element outlineElement) {
        String outlineText = outlineElement.getAttributeValue(NAME);
        if (outlineText == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineText = outlineElement.getAttributeValue(TITLE);
        } else if (outlineText == null && outlineElement.getAttributeValue(TEXT) != null) {
            outlineText = outlineElement.getAttributeValue(TEXT);
        } else if (outlineText == null) {
            outlineText = "";
        }
        outlineText = HTMLUtilities.removeHTML((String)outlineText);
        mmIStructureCell addedBranch = (mmIStructureCell)this.editorComponent.runAction((AbstractEditorAction)new AddBranchAction(this.currentParentCell, BranchType.BOX, outlineText));
        List outlineList = outlineElement.getChildren(OUTLINE);
        for (Element e : outlineList) {
            this.currentParentCell = addedBranch;
            this.parseOutlineElement(e);
            this.importProgress();
        }
    }

    private void parseOutlineElementNotes(Element outlineElement) {
        String outlineText = outlineElement.getAttributeValue(TEXT);
        if (outlineText == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineText = outlineElement.getAttributeValue(TITLE);
        } else if (outlineText == null) {
            outlineText = "";
        }
        Notes newNote = new Notes();
        newNote.setNotes(outlineText);
        this.editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.currentParentCell, "com.thinkbuzan.gaia.cell.notes", (IProperty)newNote));
    }

    private void parseOutlineElementTask(Element outlineElement) {
        boolean childElements = false;
        for (Object testObject : outlineElement.getParentElement().getChildren(OUTLINE)) {
            if (((Element)testObject).getAttributeValue(NAME) == null && ((Element)testObject).getAttributeValue(TEXT) == null) continue;
            childElements = true;
        }
        Task task = new Task();
        if (!childElements) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date start = null;
            Date end = null;
            String temp = outlineElement.getAttributeValue(START_DATE);
            try {
                start = df.parse(temp);
                task.setStartDate(start);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            temp = outlineElement.getAttributeValue(END_DATE);
            try {
                end = df.parse(temp);
                task.setDueDate(end);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        int priority = Integer.parseInt(outlineElement.getAttributeValue(PRIORITY));
        double completion = Double.parseDouble(outlineElement.getAttributeValue(COMPLETION));
        String notes = null;
        if (outlineElement.getAttribute(NOTES2) != null) {
            notes = outlineElement.getAttributeValue(NOTES2);
            task.setNote(notes);
        }
        task.setPriority(priority);
        task.setCompletion(completion);
        this.editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.currentParentCell, "com.thinkbuzan.gaia.cell.task", (IProperty)task));
    }

    private void parseOutlineElementRelationships(Element outlineElement) {
        String outlineID = outlineElement.getAttributeValue(ID);
        if (outlineID == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineID = outlineElement.getAttributeValue(TITLE);
        } else if (outlineID == null) {
            outlineID = "";
        }
        if (this.rMap.get(outlineID) != null) {
            mmIStructureCell endCell = this.rMap.get(outlineID);
            if (outlineElement.getAttributeValue(SOURCE).equalsIgnoreCase(YES)) {
                this.editorComponent.runAction((AbstractEditorAction)new AddRelationshipAction(this.currentParentCell, endCell));
            } else {
                this.editorComponent.runAction((AbstractEditorAction)new AddRelationshipAction(endCell, this.currentParentCell));
            }
        } else if (outlineID != null && !outlineID.equals("")) {
            this.rMap.put(outlineID, this.currentParentCell);
        }
    }

    private void parseOutlineElementIcons(Element outlineElement) {
        String outlineID = outlineElement.getAttributeValue(TEXT);
        if (outlineID == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineID = outlineElement.getAttributeValue(TITLE);
        } else if (outlineID == null) {
            outlineID = "";
        }
        List<String> iconIDs = Arrays.asList(outlineID.split(","));
        this.editorComponent.runAction((AbstractEditorAction)new SetIconsAction(this.currentParentCell, iconIDs));
    }

    private void parseOutlineElementBranchAndLink(Element outlineElement) {
        String outlineText = outlineElement.getAttributeValue(NAME);
        if (outlineText == null && outlineElement.getAttributeValue(TITLE) != null) {
            outlineText = outlineElement.getAttributeValue(TITLE);
        } else if (outlineText == null && outlineElement.getAttributeValue(TEXT) != null) {
            outlineText = outlineElement.getAttributeValue(TEXT);
        } else if (outlineText == null) {
            outlineText = "";
        }
        outlineText = HTMLUtilities.removeHTML((String)outlineText);
        mmIStructureCell addedBranch = (mmIStructureCell)this.editorComponent.runAction((AbstractEditorAction)new AddBranchAction(this.currentParentCell, BranchType.BRANCH, outlineText));
        String url = this.getOutlineUrl(outlineElement);
        if (url != null) {
            HyperLink hyperLink = new HyperLink();
            hyperLink.setType(HyperLinkType.WEB);
            hyperLink.setLink(url);
            List hyperLinks = PropertyUtilities.getPropertyList((mmICell)addedBranch, (String)"com.thinkbuzan.gaia.cell.hyperlinks");
            hyperLinks.add(hyperLink);
            this.editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)addedBranch, "com.thinkbuzan.gaia.cell.hyperlinks", hyperLinks));
        }
        List outlineList = outlineElement.getChildren();
        for (Element e : outlineList) {
            this.currentParentCell = addedBranch;
            this.parseOutlineElement(e);
            this.importProgress();
        }
    }

    private void parseOutlineElementLink(Element outlineElement) {
        String url = this.getOutlineUrl(outlineElement);
        if (url != null) {
            HyperLink hyperLink = new HyperLink();
            hyperLink.setType(HyperLinkType.WEB);
            hyperLink.setLink(url);
            List hyperLinks = PropertyUtilities.getPropertyList((mmICell)this.currentParentCell, (String)"com.thinkbuzan.gaia.cell.hyperlinks");
            hyperLinks.add(hyperLink);
            this.editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.currentParentCell, "com.thinkbuzan.gaia.cell.hyperlinks", hyperLinks));
        }
    }

    private String getOutlineUrl(Element outlineElement) {
        String type = outlineElement.getAttributeValue(TYPE);
        if (LINK.equals(type)) {
            return outlineElement.getAttributeValue(URL);
        }
        if (RSS.equals(type)) {
            return outlineElement.getAttributeValue("xmlUrl");
        }
        return null;
    }

    private int getChildrenCount(Element element) {
        int count = 0;
        List bodyList = element.getChildren();
        if (bodyList != null) {
            int bodyChildrenSize = bodyList.size();
            count += bodyChildrenSize;
            for (Element e : bodyList) {
                count += this.getChildrenCount(e);
            }
        }
        return count;
    }

    private void createFloatingIdeaFromBody(Element element) {
        String url;
        String ideaLabel;
        if (element != null) {
            ideaLabel = element.getAttributeValue(NAME);
            this.importProgress();
        } else {
            ideaLabel = "";
        }
        if (ideaLabel == null) {
            ideaLabel = element.getAttributeValue(TEXT);
            this.importProgress();
        }
        ideaLabel = HTMLUtilities.removeHTML((String)ideaLabel);
        this.floatingIdea = (mmIStructureCell)this.editorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(ideaLabel));
        if (element.getAttributeValue(TYPE) != null && (element.getAttributeValue(TYPE).equals(LINK) || element.getAttributeValue(TYPE).equals(RSS)) && (url = this.getOutlineUrl(element)) != null) {
            HyperLink hyperLink = new HyperLink();
            hyperLink.setType(HyperLinkType.WEB);
            hyperLink.setLink(url);
            List hyperLinks = PropertyUtilities.getPropertyList((mmICell)this.floatingIdea, (String)"com.thinkbuzan.gaia.cell.hyperlinks");
            hyperLinks.add(hyperLink);
            this.editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)this.floatingIdea, "com.thinkbuzan.gaia.cell.hyperlinks", hyperLinks));
        }
        List children = element.getChildren(OUTLINE);
        for (Element e : children) {
            this.currentParentCell = this.floatingIdea;
            this.parseOutlineElement(e);
        }
    }

    private void validateImportImpl(File file, IEditorComponent editorComponentIn, IImporterListener listenerIn) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (editorComponentIn == null) {
            throw new IllegalArgumentException("IEditorComponent can not be null.");
        }
        if (listenerIn == null) {
            throw new IllegalArgumentException("listener can not be null.");
        }
    }

    private void initProgress(Element head, Element body) {
        this.progressCount = 0;
        this.currentProgress = 0;
        int headCount = head == null ? 0 : 1;
        int bodyCount = this.getChildrenCount(body);
        this.progressCount = headCount + bodyCount;
    }

    private void checkElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
    }

    public final Icon getIcon() {
        return new ImageIcon(ResourceManager.getResourceIcon24());
    }

    public final String getId() {
        return OPMLImporter.class.getPackage().getName();
    }

    public final String getLabel() {
        return LABEL;
    }

    public final List<String> getAllowedExtensions() {
        return EXTENSIONS;
    }

    public final String getFileFilterDescription() {
        return DESCRIPTION;
    }

    public final boolean isVisible() {
        return true;
    }

    public final String getCategory() {
        return "Document";
    }

    static {
        EXTENSIONS = Arrays.asList("opml", "xml");
        LOGGER = Logger.getLogger(OPMLImporter.class);
        ICONS = "icons";
    }
}

