/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.document;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmFlowCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.AbstractTemplateExporter;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.document.options.IDocumentOptions;
import com.thinkbuzan.gaia.export.document.options.impl.DocumentOptionsComponent;
import com.thinkbuzan.gaia.export.template.ITemplate;
import com.thinkbuzan.gaia.export.template.ITemplateComponentListener;
import com.thinkbuzan.pascal.services.editor.IPainter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentExporter
extends AbstractTemplateExporter {
    private volatile transient DocumentOptionsComponent optionsComponent;
    private transient File outputFile;
    private transient IExporterListener exporterListener;
    private static final double MINDMAP_IMAGE_MAXIMUM_WIDTH = 1575.0;
    private static final double MINDMAP_IMAGE_MAXIMUM_HEIGHT = 2374.0;
    private static final transient Logger LOGGER = Logger.getLogger(AbstractDocumentExporter.class);
    private final transient Category.CategoryId catId;

    public AbstractDocumentExporter(I18n i18n, Category.CategoryId idIn) {
        super(i18n);
        if (idIn == null || !Category.CategoryId.DOCUMENT.equals((Object)idIn) && !Category.CategoryId.PDF_DOCUMENT.equals((Object)idIn)) {
            throw new IllegalArgumentException("Exported CategoryId = DOCUMENT or PDF_DOCUMENT, actual Id=" + idIn);
        }
        this.catId = idIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentOptionsComponent lazyGetOptionsComponent() {
        AbstractDocumentExporter abstractDocumentExporter = this;
        synchronized (abstractDocumentExporter) {
            if (this.optionsComponent == null) {
                this.optionsComponent = new DocumentOptionsComponent();
            }
        }
        return this.optionsComponent;
    }

    public final void export(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn) {
        this.validateExport(editorComponent, outputFileIn, exporterListenerIn);
        this.exporterListener = exporterListenerIn;
        this.outputFile = outputFileIn;
        exporterListenerIn.exportProgress(0.0f);
        this.beginDocument();
        List floatingIdeas = editorComponent.getFloatingIdeas();
        mmUtils.sortByOrder((List)floatingIdeas);
        for (mmFloatingIdeaCell idea : floatingIdeas) {
            this.writeCentralIdea(idea, editorComponent);
            this.writeBranches(idea.getChildStructures(), editorComponent);
        }
        List flowCells = editorComponent.getFlowchartCells();
        for (mmFlowCell flow : flowCells) {
            this.writeFlowChartElements(flow, editorComponent);
        }
        this.insertAppendix(editorComponent);
        if (this.getDocumentOptions().isInsertMindMapImage()) {
            try {
                this.insertMindMapImage(this.createMindMapImage(editorComponent));
            }
            catch (OutOfMemoryError memoryError) {
                LOGGER.error((Object)"Caught OutOfMemoryError when inserting Mind Map Image", (Throwable)memoryError);
            }
        }
        this.endDocument();
        exporterListenerIn.exportProgress(1.0f);
        this.exporterListener = null;
    }

    private BufferedImage createMindMapImage(IEditorComponent editorComponent) {
        IPainter painter = editorComponent.createPainter(true, false);
        painter.setBackgroundPainted(true);
        Rectangle2D size = painter.getPaintBounds();
        double xRatio = size.getWidth() / 1575.0;
        double yRatio = size.getHeight() / 2374.0;
        if (xRatio > 1.0 || yRatio > 1.0) {
            double scale = xRatio > yRatio ? 1.0 / xRatio : 1.0 / yRatio;
            painter.setScale(scale);
            size = painter.getPaintBounds();
        }
        int imageWidth = Math.max(1, (int)Math.ceil(size.getWidth()));
        int imageHeight = Math.max(1, (int)Math.ceil(size.getHeight()));
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 5);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(editorComponent.getBackgroundColor());
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        painter.paint(graphics);
        graphics.dispose();
        return image;
    }

    protected abstract void insertAppendix(IEditorComponent var1);

    public final void export(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn, Object ... objects) {
        boolean exportImage = false;
        boolean centralImage = false;
        boolean pageNumbering = false;
        boolean numberedHeadings = false;
        boolean indentedHeadings = false;
        int index = 0;
        if (objects.length > index && objects[index] instanceof Boolean) {
            exportImage = (Boolean)objects[index];
        }
        if (objects.length > ++index && objects[index] instanceof Boolean) {
            centralImage = (Boolean)objects[index];
        }
        if (objects.length > ++index && objects[index] instanceof Boolean) {
            pageNumbering = (Boolean)objects[index];
        }
        if (objects.length > ++index && objects[index] instanceof Boolean) {
            numberedHeadings = (Boolean)objects[index];
        }
        if (objects.length > ++index && objects[index] instanceof Boolean) {
            indentedHeadings = (Boolean)objects[index];
        }
        if (this.getDocumentOptions() instanceof DocumentOptionsComponent) {
            DocumentOptionsComponent documentOptionsComponent = (DocumentOptionsComponent)this.getDocumentOptions();
            documentOptionsComponent.setInsertMindMapImage(exportImage);
            documentOptionsComponent.setInsertCentralIdeaImage(centralImage);
            documentOptionsComponent.setNumberedPages(pageNumbering);
            documentOptionsComponent.setNumberedHeadings(numberedHeadings);
            documentOptionsComponent.setIndentedHeadings(indentedHeadings);
        }
        this.export(editorComponent, outputFileIn, exporterListenerIn);
    }

    private void writeBranches(List<mmIStructureCell> branches, IEditorComponent editorComponent) {
        mmUtils.sortByOrder(branches);
        for (mmIStructureCell branch : branches) {
            if (!(branch instanceof mmBranchCell)) continue;
            this.writeBranch((mmBranchCell)branch, editorComponent);
            List subBranches = branch.getChildStructures();
            if (subBranches == null) continue;
            this.writeBranches(subBranches, editorComponent);
        }
    }

    private void validateExport(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn) {
        if (editorComponent == null) {
            throw new IllegalArgumentException("Editor component can't be null!");
        }
        if (outputFileIn == null) {
            throw new IllegalArgumentException("Output file can't be null!");
        }
        if (exporterListenerIn == null) {
            throw new IllegalArgumentException("Exporter listener can't be null!");
        }
    }

    public final IExporterListener getExporterListener() {
        return this.exporterListener;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final JComponent getOptionsComponent() {
        return this.lazyGetOptionsComponent();
    }

    public final Category.CategoryId getCategoryId() {
        return this.catId;
    }

    public final IDocumentOptions getDocumentOptions() {
        return this.lazyGetOptionsComponent();
    }

    protected abstract void beginDocument();

    protected abstract void writeCentralIdea(mmFloatingIdeaCell var1, IEditorComponent var2);

    protected abstract void writeFlowChartElements(mmFlowCell var1, IEditorComponent var2);

    protected abstract void writeBranch(mmBranchCell var1, IEditorComponent var2);

    protected abstract void insertMindMapImage(Image var1);

    protected abstract void endDocument();

    protected abstract void insertTableOfContents(IEditorComponent var1);

    protected abstract void insertMapTitle(String var1);

    public ITemplateComponentListener getTemplateComponentListener() {
        return null;
    }

    public JComponent getTemplateComponent() {
        return null;
    }

    public List<ITemplate> getTemplates() {
        return null;
    }
}

