/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.document.options.impl;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.gaia.export.document.i18n.DocumentExporterI18N;
import com.thinkbuzan.gaia.export.document.options.IDocumentOptions;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DocumentOptionsComponent
extends JComponent
implements IDocumentOptions {
    private static final long serialVersionUID = 7988985256231786359L;
    private final transient JCheckBox centralImage;
    private final transient JCheckBox mindmapImage;
    private final transient JCheckBox numberedPages;
    private final transient JCheckBox numberedHeadings;
    private final transient JCheckBox indentedHeadings;
    private final transient JLabel imageNote;

    public DocumentOptionsComponent() {
        this.setOpaque(false);
        this.centralImage = CoreUIFactory.createCheckBox((String)DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.options.centralImage"));
        this.mindmapImage = CoreUIFactory.createCheckBox((String)DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.options.mindmapImage"));
        this.numberedPages = CoreUIFactory.createCheckBox((String)DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.layoutOptionsPanel.pageNumbering"));
        this.numberedHeadings = CoreUIFactory.createCheckBox((String)DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.layoutOptionsPanel.headingNumbering"));
        this.indentedHeadings = CoreUIFactory.createCheckBox((String)DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.layoutOptionsPanel.headingIndentation"));
        this.imageNote = new JLabel("(" + DocumentExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.export.document.image.suggestion") + ")");
        this.imageNote.setVisible(false);
        this.init();
    }

    private void init() {
        this.centralImage.setSelected(true);
        this.mindmapImage.setSelected(false);
        this.numberedPages.setSelected(false);
        this.numberedHeadings.setSelected(false);
        this.indentedHeadings.setSelected(false);
        JPanel mmImageWrap = this.createWapperPanel(this.mindmapImage);
        mmImageWrap.add(this.imageNote);
        this.mindmapImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocumentOptionsComponent.this.imageNote.setVisible(DocumentOptionsComponent.this.mindmapImage.isSelected());
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createWapperPanel(this.centralImage));
        this.add(mmImageWrap);
        this.add(this.createWapperPanel(this.numberedPages));
        this.add(this.createWapperPanel(this.numberedHeadings));
        this.add(this.createWapperPanel(this.indentedHeadings));
    }

    private JPanel createWapperPanel(JCheckBox checkBox) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(checkBox);
        return panel;
    }

    public final boolean isInsertCentralIdeaImage() {
        return this.centralImage.isSelected();
    }

    public final boolean isInsertMindMapImage() {
        return this.mindmapImage.isSelected();
    }

    public boolean isNumberedHeadings() {
        return this.numberedHeadings.isSelected();
    }

    public boolean isIndentedHeadings() {
        return this.indentedHeadings.isSelected();
    }

    public boolean isNumberedPages() {
        return this.numberedPages.isSelected();
    }

    public final void setInsertCentralIdeaImage(boolean selected) {
        this.centralImage.setSelected(selected);
    }

    public final void setInsertMindMapImage(boolean selected) {
        this.mindmapImage.setSelected(selected);
    }

    public final void setNumberedPages(boolean selected) {
        this.numberedPages.setSelected(selected);
    }

    public final void setNumberedHeadings(boolean selected) {
        this.numberedHeadings.setSelected(selected);
    }

    public final void setIndentedHeadings(boolean selected) {
        this.indentedHeadings.setSelected(selected);
    }
}

